<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MemberContact StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:MemberContact
 * @subpackage Structs
 */
class MemberContact extends MemberDirectory
{
    /**
     * The ConfidentialString
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ConfidentialString;
    /**
     * The ConfidentialTypeID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ConfidentialTypeID;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Description;
    /**
     * The DirectoryType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DirectoryType;
    /**
     * The DirectoryTypeStaticID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DirectoryTypeStaticID;
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ID;
    /**
     * The IsAvailabilityHiddenString
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IsAvailabilityHiddenString;
    /**
     * The IsPrimaryString
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IsPrimaryString;
    /**
     * The OldID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $OldID;
    /**
     * The OtherDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OtherDescription;
    /**
     * The SortOrder
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $SortOrder;
    /**
     * The StaticID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StaticID;
    /**
     * Constructor method for MemberContact
     * @uses MemberContact::setConfidentialString()
     * @uses MemberContact::setConfidentialTypeID()
     * @uses MemberContact::setDescription()
     * @uses MemberContact::setDirectoryType()
     * @uses MemberContact::setDirectoryTypeStaticID()
     * @uses MemberContact::setID()
     * @uses MemberContact::setIsAvailabilityHiddenString()
     * @uses MemberContact::setIsPrimaryString()
     * @uses MemberContact::setOldID()
     * @uses MemberContact::setOtherDescription()
     * @uses MemberContact::setSortOrder()
     * @uses MemberContact::setStaticID()
     * @param string $confidentialString
     * @param int $confidentialTypeID
     * @param string $description
     * @param string $directoryType
     * @param string $directoryTypeStaticID
     * @param int $iD
     * @param string $isAvailabilityHiddenString
     * @param string $isPrimaryString
     * @param int $oldID
     * @param string $otherDescription
     * @param int $sortOrder
     * @param string $staticID
     */
    public function __construct($confidentialString = null, $confidentialTypeID = null, $description = null, $directoryType = null, $directoryTypeStaticID = null, $iD = null, $isAvailabilityHiddenString = null, $isPrimaryString = null, $oldID = null, $otherDescription = null, $sortOrder = null, $staticID = null)
    {
        $this
            ->setConfidentialString($confidentialString)
            ->setConfidentialTypeID($confidentialTypeID)
            ->setDescription($description)
            ->setDirectoryType($directoryType)
            ->setDirectoryTypeStaticID($directoryTypeStaticID)
            ->setID($iD)
            ->setIsAvailabilityHiddenString($isAvailabilityHiddenString)
            ->setIsPrimaryString($isPrimaryString)
            ->setOldID($oldID)
            ->setOtherDescription($otherDescription)
            ->setSortOrder($sortOrder)
            ->setStaticID($staticID);
    }
    /**
     * Get ConfidentialString value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getConfidentialString()
    {
        return isset($this->ConfidentialString) ? $this->ConfidentialString : null;
    }
    /**
     * Set ConfidentialString value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $confidentialString
     * @return \StructType\MemberContact
     */
    public function setConfidentialString($confidentialString = null)
    {
        // validation for constraint: string
        if (!is_null($confidentialString) && !is_string($confidentialString)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($confidentialString, true), gettype($confidentialString)), __LINE__);
        }
        if (is_null($confidentialString) || (is_array($confidentialString) && empty($confidentialString))) {
            unset($this->ConfidentialString);
        } else {
            $this->ConfidentialString = $confidentialString;
        }
        return $this;
    }
    /**
     * Get ConfidentialTypeID value
     * @return int|null
     */
    public function getConfidentialTypeID()
    {
        return $this->ConfidentialTypeID;
    }
    /**
     * Set ConfidentialTypeID value
     * @param int $confidentialTypeID
     * @return \StructType\MemberContact
     */
    public function setConfidentialTypeID($confidentialTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($confidentialTypeID) && !(is_int($confidentialTypeID) || ctype_digit($confidentialTypeID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($confidentialTypeID, true), gettype($confidentialTypeID)), __LINE__);
        }
        $this->ConfidentialTypeID = $confidentialTypeID;
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $description
     * @return \StructType\MemberContact
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get DirectoryType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDirectoryType()
    {
        return isset($this->DirectoryType) ? $this->DirectoryType : null;
    }
    /**
     * Set DirectoryType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $directoryType
     * @return \StructType\MemberContact
     */
    public function setDirectoryType($directoryType = null)
    {
        // validation for constraint: string
        if (!is_null($directoryType) && !is_string($directoryType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($directoryType, true), gettype($directoryType)), __LINE__);
        }
        if (is_null($directoryType) || (is_array($directoryType) && empty($directoryType))) {
            unset($this->DirectoryType);
        } else {
            $this->DirectoryType = $directoryType;
        }
        return $this;
    }
    /**
     * Get DirectoryTypeStaticID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDirectoryTypeStaticID()
    {
        return isset($this->DirectoryTypeStaticID) ? $this->DirectoryTypeStaticID : null;
    }
    /**
     * Set DirectoryTypeStaticID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $directoryTypeStaticID
     * @return \StructType\MemberContact
     */
    public function setDirectoryTypeStaticID($directoryTypeStaticID = null)
    {
        // validation for constraint: string
        if (!is_null($directoryTypeStaticID) && !is_string($directoryTypeStaticID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($directoryTypeStaticID, true), gettype($directoryTypeStaticID)), __LINE__);
        }
        if (is_null($directoryTypeStaticID) || (is_array($directoryTypeStaticID) && empty($directoryTypeStaticID))) {
            unset($this->DirectoryTypeStaticID);
        } else {
            $this->DirectoryTypeStaticID = $directoryTypeStaticID;
        }
        return $this;
    }
    /**
     * Get ID value
     * @return int|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param int $iD
     * @return \StructType\MemberContact
     */
    public function setID($iD = null)
    {
        // validation for constraint: int
        if (!is_null($iD) && !(is_int($iD) || ctype_digit($iD))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get IsAvailabilityHiddenString value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIsAvailabilityHiddenString()
    {
        return isset($this->IsAvailabilityHiddenString) ? $this->IsAvailabilityHiddenString : null;
    }
    /**
     * Set IsAvailabilityHiddenString value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $isAvailabilityHiddenString
     * @return \StructType\MemberContact
     */
    public function setIsAvailabilityHiddenString($isAvailabilityHiddenString = null)
    {
        // validation for constraint: string
        if (!is_null($isAvailabilityHiddenString) && !is_string($isAvailabilityHiddenString)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($isAvailabilityHiddenString, true), gettype($isAvailabilityHiddenString)), __LINE__);
        }
        if (is_null($isAvailabilityHiddenString) || (is_array($isAvailabilityHiddenString) && empty($isAvailabilityHiddenString))) {
            unset($this->IsAvailabilityHiddenString);
        } else {
            $this->IsAvailabilityHiddenString = $isAvailabilityHiddenString;
        }
        return $this;
    }
    /**
     * Get IsPrimaryString value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIsPrimaryString()
    {
        return isset($this->IsPrimaryString) ? $this->IsPrimaryString : null;
    }
    /**
     * Set IsPrimaryString value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $isPrimaryString
     * @return \StructType\MemberContact
     */
    public function setIsPrimaryString($isPrimaryString = null)
    {
        // validation for constraint: string
        if (!is_null($isPrimaryString) && !is_string($isPrimaryString)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($isPrimaryString, true), gettype($isPrimaryString)), __LINE__);
        }
        if (is_null($isPrimaryString) || (is_array($isPrimaryString) && empty($isPrimaryString))) {
            unset($this->IsPrimaryString);
        } else {
            $this->IsPrimaryString = $isPrimaryString;
        }
        return $this;
    }
    /**
     * Get OldID value
     * @return int|null
     */
    public function getOldID()
    {
        return $this->OldID;
    }
    /**
     * Set OldID value
     * @param int $oldID
     * @return \StructType\MemberContact
     */
    public function setOldID($oldID = null)
    {
        // validation for constraint: int
        if (!is_null($oldID) && !(is_int($oldID) || ctype_digit($oldID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($oldID, true), gettype($oldID)), __LINE__);
        }
        $this->OldID = $oldID;
        return $this;
    }
    /**
     * Get OtherDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOtherDescription()
    {
        return isset($this->OtherDescription) ? $this->OtherDescription : null;
    }
    /**
     * Set OtherDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $otherDescription
     * @return \StructType\MemberContact
     */
    public function setOtherDescription($otherDescription = null)
    {
        // validation for constraint: string
        if (!is_null($otherDescription) && !is_string($otherDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($otherDescription, true), gettype($otherDescription)), __LINE__);
        }
        if (is_null($otherDescription) || (is_array($otherDescription) && empty($otherDescription))) {
            unset($this->OtherDescription);
        } else {
            $this->OtherDescription = $otherDescription;
        }
        return $this;
    }
    /**
     * Get SortOrder value
     * @return int|null
     */
    public function getSortOrder()
    {
        return $this->SortOrder;
    }
    /**
     * Set SortOrder value
     * @param int $sortOrder
     * @return \StructType\MemberContact
     */
    public function setSortOrder($sortOrder = null)
    {
        // validation for constraint: int
        if (!is_null($sortOrder) && !(is_int($sortOrder) || ctype_digit($sortOrder))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sortOrder, true), gettype($sortOrder)), __LINE__);
        }
        $this->SortOrder = $sortOrder;
        return $this;
    }
    /**
     * Get StaticID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStaticID()
    {
        return isset($this->StaticID) ? $this->StaticID : null;
    }
    /**
     * Set StaticID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $staticID
     * @return \StructType\MemberContact
     */
    public function setStaticID($staticID = null)
    {
        // validation for constraint: string
        if (!is_null($staticID) && !is_string($staticID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($staticID, true), gettype($staticID)), __LINE__);
        }
        if (is_null($staticID) || (is_array($staticID) && empty($staticID))) {
            unset($this->StaticID);
        } else {
            $this->StaticID = $staticID;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MemberContact
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
