<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Member StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Member
 * @subpackage Structs
 */
class Member extends DbActionBase
{
    /**
     * The AlsoKnownAs
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AlsoKnownAs;
    /**
     * The CardNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CardNumber;
    /**
     * The Craft
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Craft;
    /**
     * The CraftId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $CraftId;
    /**
     * The FirstName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FirstName;
    /**
     * The Gender
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Gender;
    /**
     * The GoGreen
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $GoGreen;
    /**
     * The HasTourCard
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $HasTourCard;
    /**
     * The JoinedDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $JoinedDate;
    /**
     * The LastName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastName;
    /**
     * The MemberID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $MemberID;
    /**
     * The MemberStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MemberStatus;
    /**
     * The MemberStatusId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $MemberStatusId;
    /**
     * The MiddleInitial
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MiddleInitial;
    /**
     * The WebPassword
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $WebPassword;
    /**
     * Constructor method for Member
     * @uses Member::setAlsoKnownAs()
     * @uses Member::setCardNumber()
     * @uses Member::setCraft()
     * @uses Member::setCraftId()
     * @uses Member::setFirstName()
     * @uses Member::setGender()
     * @uses Member::setGoGreen()
     * @uses Member::setHasTourCard()
     * @uses Member::setJoinedDate()
     * @uses Member::setLastName()
     * @uses Member::setMemberID()
     * @uses Member::setMemberStatus()
     * @uses Member::setMemberStatusId()
     * @uses Member::setMiddleInitial()
     * @uses Member::setWebPassword()
     * @param string $alsoKnownAs
     * @param string $cardNumber
     * @param string $craft
     * @param int $craftId
     * @param string $firstName
     * @param string $gender
     * @param bool $goGreen
     * @param bool $hasTourCard
     * @param string $joinedDate
     * @param string $lastName
     * @param int $memberID
     * @param string $memberStatus
     * @param int $memberStatusId
     * @param string $middleInitial
     * @param string $webPassword
     */
    public function __construct($alsoKnownAs = null, $cardNumber = null, $craft = null, $craftId = null, $firstName = null, $gender = null, $goGreen = null, $hasTourCard = null, $joinedDate = null, $lastName = null, $memberID = null, $memberStatus = null, $memberStatusId = null, $middleInitial = null, $webPassword = null)
    {
        $this
            ->setAlsoKnownAs($alsoKnownAs)
            ->setCardNumber($cardNumber)
            ->setCraft($craft)
            ->setCraftId($craftId)
            ->setFirstName($firstName)
            ->setGender($gender)
            ->setGoGreen($goGreen)
            ->setHasTourCard($hasTourCard)
            ->setJoinedDate($joinedDate)
            ->setLastName($lastName)
            ->setMemberID($memberID)
            ->setMemberStatus($memberStatus)
            ->setMemberStatusId($memberStatusId)
            ->setMiddleInitial($middleInitial)
            ->setWebPassword($webPassword);
    }
    /**
     * Get AlsoKnownAs value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAlsoKnownAs()
    {
        return isset($this->AlsoKnownAs) ? $this->AlsoKnownAs : null;
    }
    /**
     * Set AlsoKnownAs value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $alsoKnownAs
     * @return \StructType\Member
     */
    public function setAlsoKnownAs($alsoKnownAs = null)
    {
        // validation for constraint: string
        if (!is_null($alsoKnownAs) && !is_string($alsoKnownAs)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($alsoKnownAs, true), gettype($alsoKnownAs)), __LINE__);
        }
        if (is_null($alsoKnownAs) || (is_array($alsoKnownAs) && empty($alsoKnownAs))) {
            unset($this->AlsoKnownAs);
        } else {
            $this->AlsoKnownAs = $alsoKnownAs;
        }
        return $this;
    }
    /**
     * Get CardNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCardNumber()
    {
        return isset($this->CardNumber) ? $this->CardNumber : null;
    }
    /**
     * Set CardNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cardNumber
     * @return \StructType\Member
     */
    public function setCardNumber($cardNumber = null)
    {
        // validation for constraint: string
        if (!is_null($cardNumber) && !is_string($cardNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardNumber, true), gettype($cardNumber)), __LINE__);
        }
        if (is_null($cardNumber) || (is_array($cardNumber) && empty($cardNumber))) {
            unset($this->CardNumber);
        } else {
            $this->CardNumber = $cardNumber;
        }
        return $this;
    }
    /**
     * Get Craft value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCraft()
    {
        return isset($this->Craft) ? $this->Craft : null;
    }
    /**
     * Set Craft value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $craft
     * @return \StructType\Member
     */
    public function setCraft($craft = null)
    {
        // validation for constraint: string
        if (!is_null($craft) && !is_string($craft)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($craft, true), gettype($craft)), __LINE__);
        }
        if (is_null($craft) || (is_array($craft) && empty($craft))) {
            unset($this->Craft);
        } else {
            $this->Craft = $craft;
        }
        return $this;
    }
    /**
     * Get CraftId value
     * @return int|null
     */
    public function getCraftId()
    {
        return $this->CraftId;
    }
    /**
     * Set CraftId value
     * @param int $craftId
     * @return \StructType\Member
     */
    public function setCraftId($craftId = null)
    {
        // validation for constraint: int
        if (!is_null($craftId) && !(is_int($craftId) || ctype_digit($craftId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($craftId, true), gettype($craftId)), __LINE__);
        }
        $this->CraftId = $craftId;
        return $this;
    }
    /**
     * Get FirstName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFirstName()
    {
        return isset($this->FirstName) ? $this->FirstName : null;
    }
    /**
     * Set FirstName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $firstName
     * @return \StructType\Member
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstName, true), gettype($firstName)), __LINE__);
        }
        if (is_null($firstName) || (is_array($firstName) && empty($firstName))) {
            unset($this->FirstName);
        } else {
            $this->FirstName = $firstName;
        }
        return $this;
    }
    /**
     * Get Gender value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGender()
    {
        return isset($this->Gender) ? $this->Gender : null;
    }
    /**
     * Set Gender value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gender
     * @return \StructType\Member
     */
    public function setGender($gender = null)
    {
        // validation for constraint: string
        if (!is_null($gender) && !is_string($gender)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gender, true), gettype($gender)), __LINE__);
        }
        if (is_null($gender) || (is_array($gender) && empty($gender))) {
            unset($this->Gender);
        } else {
            $this->Gender = $gender;
        }
        return $this;
    }
    /**
     * Get GoGreen value
     * @return bool|null
     */
    public function getGoGreen()
    {
        return $this->GoGreen;
    }
    /**
     * Set GoGreen value
     * @param bool $goGreen
     * @return \StructType\Member
     */
    public function setGoGreen($goGreen = null)
    {
        // validation for constraint: boolean
        if (!is_null($goGreen) && !is_bool($goGreen)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($goGreen, true), gettype($goGreen)), __LINE__);
        }
        $this->GoGreen = $goGreen;
        return $this;
    }
    /**
     * Get HasTourCard value
     * @return bool|null
     */
    public function getHasTourCard()
    {
        return $this->HasTourCard;
    }
    /**
     * Set HasTourCard value
     * @param bool $hasTourCard
     * @return \StructType\Member
     */
    public function setHasTourCard($hasTourCard = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasTourCard) && !is_bool($hasTourCard)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hasTourCard, true), gettype($hasTourCard)), __LINE__);
        }
        $this->HasTourCard = $hasTourCard;
        return $this;
    }
    /**
     * Get JoinedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getJoinedDate()
    {
        return isset($this->JoinedDate) ? $this->JoinedDate : null;
    }
    /**
     * Set JoinedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $joinedDate
     * @return \StructType\Member
     */
    public function setJoinedDate($joinedDate = null)
    {
        // validation for constraint: string
        if (!is_null($joinedDate) && !is_string($joinedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($joinedDate, true), gettype($joinedDate)), __LINE__);
        }
        if (is_null($joinedDate) || (is_array($joinedDate) && empty($joinedDate))) {
            unset($this->JoinedDate);
        } else {
            $this->JoinedDate = $joinedDate;
        }
        return $this;
    }
    /**
     * Get LastName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastName()
    {
        return isset($this->LastName) ? $this->LastName : null;
    }
    /**
     * Set LastName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastName
     * @return \StructType\Member
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastName, true), gettype($lastName)), __LINE__);
        }
        if (is_null($lastName) || (is_array($lastName) && empty($lastName))) {
            unset($this->LastName);
        } else {
            $this->LastName = $lastName;
        }
        return $this;
    }
    /**
     * Get MemberID value
     * @return int|null
     */
    public function getMemberID()
    {
        return $this->MemberID;
    }
    /**
     * Set MemberID value
     * @param int $memberID
     * @return \StructType\Member
     */
    public function setMemberID($memberID = null)
    {
        // validation for constraint: int
        if (!is_null($memberID) && !(is_int($memberID) || ctype_digit($memberID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($memberID, true), gettype($memberID)), __LINE__);
        }
        $this->MemberID = $memberID;
        return $this;
    }
    /**
     * Get MemberStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMemberStatus()
    {
        return isset($this->MemberStatus) ? $this->MemberStatus : null;
    }
    /**
     * Set MemberStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $memberStatus
     * @return \StructType\Member
     */
    public function setMemberStatus($memberStatus = null)
    {
        // validation for constraint: string
        if (!is_null($memberStatus) && !is_string($memberStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memberStatus, true), gettype($memberStatus)), __LINE__);
        }
        if (is_null($memberStatus) || (is_array($memberStatus) && empty($memberStatus))) {
            unset($this->MemberStatus);
        } else {
            $this->MemberStatus = $memberStatus;
        }
        return $this;
    }
    /**
     * Get MemberStatusId value
     * @return int|null
     */
    public function getMemberStatusId()
    {
        return $this->MemberStatusId;
    }
    /**
     * Set MemberStatusId value
     * @param int $memberStatusId
     * @return \StructType\Member
     */
    public function setMemberStatusId($memberStatusId = null)
    {
        // validation for constraint: int
        if (!is_null($memberStatusId) && !(is_int($memberStatusId) || ctype_digit($memberStatusId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($memberStatusId, true), gettype($memberStatusId)), __LINE__);
        }
        $this->MemberStatusId = $memberStatusId;
        return $this;
    }
    /**
     * Get MiddleInitial value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMiddleInitial()
    {
        return isset($this->MiddleInitial) ? $this->MiddleInitial : null;
    }
    /**
     * Set MiddleInitial value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $middleInitial
     * @return \StructType\Member
     */
    public function setMiddleInitial($middleInitial = null)
    {
        // validation for constraint: string
        if (!is_null($middleInitial) && !is_string($middleInitial)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($middleInitial, true), gettype($middleInitial)), __LINE__);
        }
        if (is_null($middleInitial) || (is_array($middleInitial) && empty($middleInitial))) {
            unset($this->MiddleInitial);
        } else {
            $this->MiddleInitial = $middleInitial;
        }
        return $this;
    }
    /**
     * Get WebPassword value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWebPassword()
    {
        return isset($this->WebPassword) ? $this->WebPassword : null;
    }
    /**
     * Set WebPassword value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $webPassword
     * @return \StructType\Member
     */
    public function setWebPassword($webPassword = null)
    {
        // validation for constraint: string
        if (!is_null($webPassword) && !is_string($webPassword)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($webPassword, true), gettype($webPassword)), __LINE__);
        }
        if (is_null($webPassword) || (is_array($webPassword) && empty($webPassword))) {
            unset($this->WebPassword);
        } else {
            $this->WebPassword = $webPassword;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Member
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
