<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MemberContactInsert StructType
 * @subpackage Structs
 */
class MemberContactInsert extends AbstractStructBase
{
    /**
     * The webServiceCredentials
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ServiceCredential
     */
    public $webServiceCredentials;
    /**
     * The contact
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\MemberContact
     */
    public $contact;
    /**
     * Constructor method for MemberContactInsert
     * @uses MemberContactInsert::setWebServiceCredentials()
     * @uses MemberContactInsert::setContact()
     * @param \StructType\ServiceCredential $webServiceCredentials
     * @param \StructType\MemberContact $contact
     */
    public function __construct(\StructType\ServiceCredential $webServiceCredentials = null, \StructType\MemberContact $contact = null)
    {
        $this
            ->setWebServiceCredentials($webServiceCredentials)
            ->setContact($contact);
    }
    /**
     * Get webServiceCredentials value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ServiceCredential|null
     */
    public function getWebServiceCredentials()
    {
        return isset($this->webServiceCredentials) ? $this->webServiceCredentials : null;
    }
    /**
     * Set webServiceCredentials value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ServiceCredential $webServiceCredentials
     * @return \StructType\MemberContactInsert
     */
    public function setWebServiceCredentials(\StructType\ServiceCredential $webServiceCredentials = null)
    {
        if (is_null($webServiceCredentials) || (is_array($webServiceCredentials) && empty($webServiceCredentials))) {
            unset($this->webServiceCredentials);
        } else {
            $this->webServiceCredentials = $webServiceCredentials;
        }
        return $this;
    }
    /**
     * Get contact value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\MemberContact|null
     */
    public function getContact()
    {
        return isset($this->contact) ? $this->contact : null;
    }
    /**
     * Set contact value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\MemberContact $contact
     * @return \StructType\MemberContactInsert
     */
    public function setContact(\StructType\MemberContact $contact = null)
    {
        if (is_null($contact) || (is_array($contact) && empty($contact))) {
            unset($this->contact);
        } else {
            $this->contact = $contact;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MemberContactInsert
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
