<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InvoiceDetail StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:InvoiceDetail
 * @subpackage Structs
 */
class InvoiceDetail extends DbActionBase
{
    /**
     * The Balance
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Balance;
    /**
     * The BillingMonth
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $BillingMonth;
    /**
     * The BillingYear
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $BillingYear;
    /**
     * The ChargeAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $ChargeAmount;
    /**
     * The ChargeType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ChargeType;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Description;
    /**
     * The DueDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DueDate;
    /**
     * The EntryDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $EntryDate;
    /**
     * The InvoiceItemId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $InvoiceItemId;
    /**
     * The MemberId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $MemberId;
    /**
     * The PaymentAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $PaymentAmount;
    /**
     * The Sort
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Sort;
    /**
     * Constructor method for InvoiceDetail
     * @uses InvoiceDetail::setBalance()
     * @uses InvoiceDetail::setBillingMonth()
     * @uses InvoiceDetail::setBillingYear()
     * @uses InvoiceDetail::setChargeAmount()
     * @uses InvoiceDetail::setChargeType()
     * @uses InvoiceDetail::setDescription()
     * @uses InvoiceDetail::setDueDate()
     * @uses InvoiceDetail::setEntryDate()
     * @uses InvoiceDetail::setInvoiceItemId()
     * @uses InvoiceDetail::setMemberId()
     * @uses InvoiceDetail::setPaymentAmount()
     * @uses InvoiceDetail::setSort()
     * @param float $balance
     * @param int $billingMonth
     * @param int $billingYear
     * @param float $chargeAmount
     * @param string $chargeType
     * @param string $description
     * @param string $dueDate
     * @param string $entryDate
     * @param int $invoiceItemId
     * @param int $memberId
     * @param float $paymentAmount
     * @param int $sort
     */
    public function __construct($balance = null, $billingMonth = null, $billingYear = null, $chargeAmount = null, $chargeType = null, $description = null, $dueDate = null, $entryDate = null, $invoiceItemId = null, $memberId = null, $paymentAmount = null, $sort = null)
    {
        $this
            ->setBalance($balance)
            ->setBillingMonth($billingMonth)
            ->setBillingYear($billingYear)
            ->setChargeAmount($chargeAmount)
            ->setChargeType($chargeType)
            ->setDescription($description)
            ->setDueDate($dueDate)
            ->setEntryDate($entryDate)
            ->setInvoiceItemId($invoiceItemId)
            ->setMemberId($memberId)
            ->setPaymentAmount($paymentAmount)
            ->setSort($sort);
    }
    /**
     * Get Balance value
     * @return float|null
     */
    public function getBalance()
    {
        return $this->Balance;
    }
    /**
     * Set Balance value
     * @param float $balance
     * @return \StructType\InvoiceDetail
     */
    public function setBalance($balance = null)
    {
        // validation for constraint: float
        if (!is_null($balance) && !(is_float($balance) || is_numeric($balance))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($balance, true), gettype($balance)), __LINE__);
        }
        $this->Balance = $balance;
        return $this;
    }
    /**
     * Get BillingMonth value
     * @return int|null
     */
    public function getBillingMonth()
    {
        return $this->BillingMonth;
    }
    /**
     * Set BillingMonth value
     * @param int $billingMonth
     * @return \StructType\InvoiceDetail
     */
    public function setBillingMonth($billingMonth = null)
    {
        // validation for constraint: int
        if (!is_null($billingMonth) && !(is_int($billingMonth) || ctype_digit($billingMonth))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($billingMonth, true), gettype($billingMonth)), __LINE__);
        }
        $this->BillingMonth = $billingMonth;
        return $this;
    }
    /**
     * Get BillingYear value
     * @return int|null
     */
    public function getBillingYear()
    {
        return $this->BillingYear;
    }
    /**
     * Set BillingYear value
     * @param int $billingYear
     * @return \StructType\InvoiceDetail
     */
    public function setBillingYear($billingYear = null)
    {
        // validation for constraint: int
        if (!is_null($billingYear) && !(is_int($billingYear) || ctype_digit($billingYear))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($billingYear, true), gettype($billingYear)), __LINE__);
        }
        $this->BillingYear = $billingYear;
        return $this;
    }
    /**
     * Get ChargeAmount value
     * @return float|null
     */
    public function getChargeAmount()
    {
        return $this->ChargeAmount;
    }
    /**
     * Set ChargeAmount value
     * @param float $chargeAmount
     * @return \StructType\InvoiceDetail
     */
    public function setChargeAmount($chargeAmount = null)
    {
        // validation for constraint: float
        if (!is_null($chargeAmount) && !(is_float($chargeAmount) || is_numeric($chargeAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($chargeAmount, true), gettype($chargeAmount)), __LINE__);
        }
        $this->ChargeAmount = $chargeAmount;
        return $this;
    }
    /**
     * Get ChargeType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getChargeType()
    {
        return isset($this->ChargeType) ? $this->ChargeType : null;
    }
    /**
     * Set ChargeType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $chargeType
     * @return \StructType\InvoiceDetail
     */
    public function setChargeType($chargeType = null)
    {
        // validation for constraint: string
        if (!is_null($chargeType) && !is_string($chargeType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($chargeType, true), gettype($chargeType)), __LINE__);
        }
        if (is_null($chargeType) || (is_array($chargeType) && empty($chargeType))) {
            unset($this->ChargeType);
        } else {
            $this->ChargeType = $chargeType;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $description
     * @return \StructType\InvoiceDetail
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get DueDate value
     * @return string|null
     */
    public function getDueDate()
    {
        return $this->DueDate;
    }
    /**
     * Set DueDate value
     * @param string $dueDate
     * @return \StructType\InvoiceDetail
     */
    public function setDueDate($dueDate = null)
    {
        // validation for constraint: string
        if (!is_null($dueDate) && !is_string($dueDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dueDate, true), gettype($dueDate)), __LINE__);
        }
        $this->DueDate = $dueDate;
        return $this;
    }
    /**
     * Get EntryDate value
     * @return string|null
     */
    public function getEntryDate()
    {
        return $this->EntryDate;
    }
    /**
     * Set EntryDate value
     * @param string $entryDate
     * @return \StructType\InvoiceDetail
     */
    public function setEntryDate($entryDate = null)
    {
        // validation for constraint: string
        if (!is_null($entryDate) && !is_string($entryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($entryDate, true), gettype($entryDate)), __LINE__);
        }
        $this->EntryDate = $entryDate;
        return $this;
    }
    /**
     * Get InvoiceItemId value
     * @return int|null
     */
    public function getInvoiceItemId()
    {
        return $this->InvoiceItemId;
    }
    /**
     * Set InvoiceItemId value
     * @param int $invoiceItemId
     * @return \StructType\InvoiceDetail
     */
    public function setInvoiceItemId($invoiceItemId = null)
    {
        // validation for constraint: int
        if (!is_null($invoiceItemId) && !(is_int($invoiceItemId) || ctype_digit($invoiceItemId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($invoiceItemId, true), gettype($invoiceItemId)), __LINE__);
        }
        $this->InvoiceItemId = $invoiceItemId;
        return $this;
    }
    /**
     * Get MemberId value
     * @return int|null
     */
    public function getMemberId()
    {
        return $this->MemberId;
    }
    /**
     * Set MemberId value
     * @param int $memberId
     * @return \StructType\InvoiceDetail
     */
    public function setMemberId($memberId = null)
    {
        // validation for constraint: int
        if (!is_null($memberId) && !(is_int($memberId) || ctype_digit($memberId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($memberId, true), gettype($memberId)), __LINE__);
        }
        $this->MemberId = $memberId;
        return $this;
    }
    /**
     * Get PaymentAmount value
     * @return float|null
     */
    public function getPaymentAmount()
    {
        return $this->PaymentAmount;
    }
    /**
     * Set PaymentAmount value
     * @param float $paymentAmount
     * @return \StructType\InvoiceDetail
     */
    public function setPaymentAmount($paymentAmount = null)
    {
        // validation for constraint: float
        if (!is_null($paymentAmount) && !(is_float($paymentAmount) || is_numeric($paymentAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($paymentAmount, true), gettype($paymentAmount)), __LINE__);
        }
        $this->PaymentAmount = $paymentAmount;
        return $this;
    }
    /**
     * Get Sort value
     * @return int|null
     */
    public function getSort()
    {
        return $this->Sort;
    }
    /**
     * Set Sort value
     * @param int $sort
     * @return \StructType\InvoiceDetail
     */
    public function setSort($sort = null)
    {
        // validation for constraint: int
        if (!is_null($sort) && !(is_int($sort) || ctype_digit($sort))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sort, true), gettype($sort)), __LINE__);
        }
        $this->Sort = $sort;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\InvoiceDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
