<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MemberPasswordUpdate StructType
 * @subpackage Structs
 */
class MemberPasswordUpdate extends AbstractStructBase
{
    /**
     * The webServiceCredentials
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ServiceCredential
     */
    public $webServiceCredentials;
    /**
     * The username
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $username;
    /**
     * The oldPassword
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $oldPassword;
    /**
     * The newPassword
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $newPassword;
    /**
     * Constructor method for MemberPasswordUpdate
     * @uses MemberPasswordUpdate::setWebServiceCredentials()
     * @uses MemberPasswordUpdate::setUsername()
     * @uses MemberPasswordUpdate::setOldPassword()
     * @uses MemberPasswordUpdate::setNewPassword()
     * @param \StructType\ServiceCredential $webServiceCredentials
     * @param string $username
     * @param string $oldPassword
     * @param string $newPassword
     */
    public function __construct(\StructType\ServiceCredential $webServiceCredentials = null, $username = null, $oldPassword = null, $newPassword = null)
    {
        $this
            ->setWebServiceCredentials($webServiceCredentials)
            ->setUsername($username)
            ->setOldPassword($oldPassword)
            ->setNewPassword($newPassword);
    }
    /**
     * Get webServiceCredentials value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ServiceCredential|null
     */
    public function getWebServiceCredentials()
    {
        return isset($this->webServiceCredentials) ? $this->webServiceCredentials : null;
    }
    /**
     * Set webServiceCredentials value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ServiceCredential $webServiceCredentials
     * @return \StructType\MemberPasswordUpdate
     */
    public function setWebServiceCredentials(\StructType\ServiceCredential $webServiceCredentials = null)
    {
        if (is_null($webServiceCredentials) || (is_array($webServiceCredentials) && empty($webServiceCredentials))) {
            unset($this->webServiceCredentials);
        } else {
            $this->webServiceCredentials = $webServiceCredentials;
        }
        return $this;
    }
    /**
     * Get username value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUsername()
    {
        return isset($this->username) ? $this->username : null;
    }
    /**
     * Set username value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $username
     * @return \StructType\MemberPasswordUpdate
     */
    public function setUsername($username = null)
    {
        // validation for constraint: string
        if (!is_null($username) && !is_string($username)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($username, true), gettype($username)), __LINE__);
        }
        if (is_null($username) || (is_array($username) && empty($username))) {
            unset($this->username);
        } else {
            $this->username = $username;
        }
        return $this;
    }
    /**
     * Get oldPassword value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOldPassword()
    {
        return isset($this->oldPassword) ? $this->oldPassword : null;
    }
    /**
     * Set oldPassword value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $oldPassword
     * @return \StructType\MemberPasswordUpdate
     */
    public function setOldPassword($oldPassword = null)
    {
        // validation for constraint: string
        if (!is_null($oldPassword) && !is_string($oldPassword)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($oldPassword, true), gettype($oldPassword)), __LINE__);
        }
        if (is_null($oldPassword) || (is_array($oldPassword) && empty($oldPassword))) {
            unset($this->oldPassword);
        } else {
            $this->oldPassword = $oldPassword;
        }
        return $this;
    }
    /**
     * Get newPassword value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNewPassword()
    {
        return isset($this->newPassword) ? $this->newPassword : null;
    }
    /**
     * Set newPassword value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $newPassword
     * @return \StructType\MemberPasswordUpdate
     */
    public function setNewPassword($newPassword = null)
    {
        // validation for constraint: string
        if (!is_null($newPassword) && !is_string($newPassword)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newPassword, true), gettype($newPassword)), __LINE__);
        }
        if (is_null($newPassword) || (is_array($newPassword) && empty($newPassword))) {
            unset($this->newPassword);
        } else {
            $this->newPassword = $newPassword;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MemberPasswordUpdate
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
