<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MemberPackage StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:MemberPackage
 * @subpackage Structs
 */
class MemberPackage extends AbstractStructBase
{
    /**
     * The MemberAddressData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfMemberAddress
     */
    public $MemberAddressData;
    /**
     * The MemberContactData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfMemberContact
     */
    public $MemberContactData;
    /**
     * The MemberData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Member
     */
    public $MemberData;
    /**
     * Constructor method for MemberPackage
     * @uses MemberPackage::setMemberAddressData()
     * @uses MemberPackage::setMemberContactData()
     * @uses MemberPackage::setMemberData()
     * @param \ArrayType\ArrayOfMemberAddress $memberAddressData
     * @param \ArrayType\ArrayOfMemberContact $memberContactData
     * @param \StructType\Member $memberData
     */
    public function __construct(\ArrayType\ArrayOfMemberAddress $memberAddressData = null, \ArrayType\ArrayOfMemberContact $memberContactData = null, \StructType\Member $memberData = null)
    {
        $this
            ->setMemberAddressData($memberAddressData)
            ->setMemberContactData($memberContactData)
            ->setMemberData($memberData);
    }
    /**
     * Get MemberAddressData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfMemberAddress|null
     */
    public function getMemberAddressData()
    {
        return isset($this->MemberAddressData) ? $this->MemberAddressData : null;
    }
    /**
     * Set MemberAddressData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfMemberAddress $memberAddressData
     * @return \StructType\MemberPackage
     */
    public function setMemberAddressData(\ArrayType\ArrayOfMemberAddress $memberAddressData = null)
    {
        if (is_null($memberAddressData) || (is_array($memberAddressData) && empty($memberAddressData))) {
            unset($this->MemberAddressData);
        } else {
            $this->MemberAddressData = $memberAddressData;
        }
        return $this;
    }
    /**
     * Get MemberContactData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfMemberContact|null
     */
    public function getMemberContactData()
    {
        return isset($this->MemberContactData) ? $this->MemberContactData : null;
    }
    /**
     * Set MemberContactData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfMemberContact $memberContactData
     * @return \StructType\MemberPackage
     */
    public function setMemberContactData(\ArrayType\ArrayOfMemberContact $memberContactData = null)
    {
        if (is_null($memberContactData) || (is_array($memberContactData) && empty($memberContactData))) {
            unset($this->MemberContactData);
        } else {
            $this->MemberContactData = $memberContactData;
        }
        return $this;
    }
    /**
     * Get MemberData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Member|null
     */
    public function getMemberData()
    {
        return isset($this->MemberData) ? $this->MemberData : null;
    }
    /**
     * Set MemberData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Member $memberData
     * @return \StructType\MemberPackage
     */
    public function setMemberData(\StructType\Member $memberData = null)
    {
        if (is_null($memberData) || (is_array($memberData) && empty($memberData))) {
            unset($this->MemberData);
        } else {
            $this->MemberData = $memberData;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MemberPackage
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
