<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Member ServiceType
 * @subpackage Services
 */
class Member extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named MemberById
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\MemberById $parameters
     * @return \StructType\MemberByIdResponse|bool
     */
    public function MemberById(\StructType\MemberById $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->MemberById($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named MemberContactsById
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\MemberContactsById $parameters
     * @return \StructType\MemberContactsByIdResponse|bool
     */
    public function MemberContactsById(\StructType\MemberContactsById $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->MemberContactsById($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named MemberAddressesById
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\MemberAddressesById $parameters
     * @return \StructType\MemberAddressesByIdResponse|bool
     */
    public function MemberAddressesById(\StructType\MemberAddressesById $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->MemberAddressesById($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named MemberSearchFilterAllCriteria
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\MemberSearchFilterAllCriteria $parameters
     * @return \StructType\MemberSearchFilterAllCriteriaResponse|bool
     */
    public function MemberSearchFilterAllCriteria(\StructType\MemberSearchFilterAllCriteria $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->MemberSearchFilterAllCriteria($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named MemberDirectorySearch
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\MemberDirectorySearch $parameters
     * @return \StructType\MemberDirectorySearchResponse|bool
     */
    public function MemberDirectorySearch(\StructType\MemberDirectorySearch $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->MemberDirectorySearch($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named MemberPasswordUpdate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\MemberPasswordUpdate $parameters
     * @return \StructType\MemberPasswordUpdateResponse|bool
     */
    public function MemberPasswordUpdate(\StructType\MemberPasswordUpdate $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->MemberPasswordUpdate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named MemberUpdate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\MemberUpdate $parameters
     * @return \StructType\MemberUpdateResponse|bool
     */
    public function MemberUpdate(\StructType\MemberUpdate $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->MemberUpdate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named MemberDirectoryDelete
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\MemberDirectoryDelete $parameters
     * @return \StructType\MemberDirectoryDeleteResponse|bool
     */
    public function MemberDirectoryDelete(\StructType\MemberDirectoryDelete $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->MemberDirectoryDelete($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named MemberDirectoryInsert
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\MemberDirectoryInsert $parameters
     * @return \StructType\MemberDirectoryInsertResponse|bool
     */
    public function MemberDirectoryInsert(\StructType\MemberDirectoryInsert $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->MemberDirectoryInsert($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named MemberDirectoryUpdate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\MemberDirectoryUpdate $parameters
     * @return \StructType\MemberDirectoryUpdateResponse|bool
     */
    public function MemberDirectoryUpdate(\StructType\MemberDirectoryUpdate $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->MemberDirectoryUpdate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named MemberContactDelete
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\MemberContactDelete $parameters
     * @return \StructType\MemberContactDeleteResponse|bool
     */
    public function MemberContactDelete(\StructType\MemberContactDelete $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->MemberContactDelete($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named MemberContactInsert
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\MemberContactInsert $parameters
     * @return \StructType\MemberContactInsertResponse|bool
     */
    public function MemberContactInsert(\StructType\MemberContactInsert $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->MemberContactInsert($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named MemberContactUpdate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\MemberContactUpdate $parameters
     * @return \StructType\MemberContactUpdateResponse|bool
     */
    public function MemberContactUpdate(\StructType\MemberContactUpdate $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->MemberContactUpdate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named MemberAddressDelete
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\MemberAddressDelete $parameters
     * @return \StructType\MemberAddressDeleteResponse|bool
     */
    public function MemberAddressDelete(\StructType\MemberAddressDelete $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->MemberAddressDelete($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named MemberAddressInsert
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\MemberAddressInsert $parameters
     * @return \StructType\MemberAddressInsertResponse|bool
     */
    public function MemberAddressInsert(\StructType\MemberAddressInsert $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->MemberAddressInsert($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named MemberAddressUpdate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\MemberAddressUpdate $parameters
     * @return \StructType\MemberAddressUpdateResponse|bool
     */
    public function MemberAddressUpdate(\StructType\MemberAddressUpdate $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->MemberAddressUpdate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named MemberAvailabilityUpdate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\MemberAvailabilityUpdate $parameters
     * @return \StructType\MemberAvailabilityUpdateResponse|bool
     */
    public function MemberAvailabilityUpdate(\StructType\MemberAvailabilityUpdate $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->MemberAvailabilityUpdate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named MemberConfidentialityTypes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\MemberConfidentialityTypes $parameters
     * @return \StructType\MemberConfidentialityTypesResponse|bool
     */
    public function MemberConfidentialityTypes(\StructType\MemberConfidentialityTypes $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->MemberConfidentialityTypes($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named MemberDirectoryTypes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\MemberDirectoryTypes $parameters
     * @return \StructType\MemberDirectoryTypesResponse|bool
     */
    public function MemberDirectoryTypes(\StructType\MemberDirectoryTypes $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->MemberDirectoryTypes($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named MemberCraftTypes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\MemberCraftTypes $parameters
     * @return \StructType\MemberCraftTypesResponse|bool
     */
    public function MemberCraftTypes(\StructType\MemberCraftTypes $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->MemberCraftTypes($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named MemberStatusTypes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\MemberStatusTypes $parameters
     * @return \StructType\MemberStatusTypesResponse|bool
     */
    public function MemberStatusTypes(\StructType\MemberStatusTypes $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->MemberStatusTypes($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named MemberAddressTypes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\MemberAddressTypes $parameters
     * @return \StructType\MemberAddressTypesResponse|bool
     */
    public function MemberAddressTypes(\StructType\MemberAddressTypes $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->MemberAddressTypes($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\MemberAddressDeleteResponse|\StructType\MemberAddressesByIdResponse|\StructType\MemberAddressInsertResponse|\StructType\MemberAddressTypesResponse|\StructType\MemberAddressUpdateResponse|\StructType\MemberAvailabilityUpdateResponse|\StructType\MemberByIdResponse|\StructType\MemberConfidentialityTypesResponse|\StructType\MemberContactDeleteResponse|\StructType\MemberContactInsertResponse|\StructType\MemberContactsByIdResponse|\StructType\MemberContactUpdateResponse|\StructType\MemberCraftTypesResponse|\StructType\MemberDirectoryDeleteResponse|\StructType\MemberDirectoryInsertResponse|\StructType\MemberDirectorySearchResponse|\StructType\MemberDirectoryTypesResponse|\StructType\MemberDirectoryUpdateResponse|\StructType\MemberPasswordUpdateResponse|\StructType\MemberSearchFilterAllCriteriaResponse|\StructType\MemberStatusTypesResponse|\StructType\MemberUpdateResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
