<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfReportWork ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfReportWork
 * @subpackage Arrays
 */
class ArrayOfReportWork extends AbstractStructArrayBase
{
    /**
     * The ReportWork
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ReportWork[]
     */
    public $ReportWork;
    /**
     * Constructor method for ArrayOfReportWork
     * @uses ArrayOfReportWork::setReportWork()
     * @param \StructType\ReportWork[] $reportWork
     */
    public function __construct(array $reportWork = array())
    {
        $this
            ->setReportWork($reportWork);
    }
    /**
     * Get ReportWork value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ReportWork[]|null
     */
    public function getReportWork()
    {
        return isset($this->ReportWork) ? $this->ReportWork : null;
    }
    /**
     * This method is responsible for validating the values passed to the setReportWork method
     * This method is willingly generated in order to preserve the one-line inline validation within the setReportWork method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateReportWorkForArrayConstraintsFromSetReportWork(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfReportWorkReportWorkItem) {
            // validation for constraint: itemType
            if (!$arrayOfReportWorkReportWorkItem instanceof \StructType\ReportWork) {
                $invalidValues[] = is_object($arrayOfReportWorkReportWorkItem) ? get_class($arrayOfReportWorkReportWorkItem) : sprintf('%s(%s)', gettype($arrayOfReportWorkReportWorkItem), var_export($arrayOfReportWorkReportWorkItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ReportWork property can only contain items of type \StructType\ReportWork, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ReportWork value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ReportWork[] $reportWork
     * @return \ArrayType\ArrayOfReportWork
     */
    public function setReportWork(array $reportWork = array())
    {
        // validation for constraint: array
        if ('' !== ($reportWorkArrayErrorMessage = self::validateReportWorkForArrayConstraintsFromSetReportWork($reportWork))) {
            throw new \InvalidArgumentException($reportWorkArrayErrorMessage, __LINE__);
        }
        if (is_null($reportWork) || (is_array($reportWork) && empty($reportWork))) {
            unset($this->ReportWork);
        } else {
            $this->ReportWork = $reportWork;
        }
        return $this;
    }
    /**
     * Add item to ReportWork value
     * @throws \InvalidArgumentException
     * @param \StructType\ReportWork $item
     * @return \ArrayType\ArrayOfReportWork
     */
    public function addToReportWork(\StructType\ReportWork $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ReportWork) {
            throw new \InvalidArgumentException(sprintf('The ReportWork property can only contain items of type \StructType\ReportWork, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ReportWork[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ReportWork|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ReportWork|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ReportWork|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ReportWork|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ReportWork|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ReportWork
     */
    public function getAttributeName()
    {
        return 'ReportWork';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfReportWork
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
