<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MemberDirectory StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:MemberDirectory
 * @subpackage Structs
 */
class MemberDirectory extends DbActionBase
{
    /**
     * The ConfidentialTypeID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ConfidentialTypeID;
    /**
     * The CreateBy
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreateBy;
    /**
     * The CreateDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreateDate;
    /**
     * The DirectoryData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DirectoryData;
    /**
     * The IsPrimary
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsPrimary;
    /**
     * The IsRoster
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsRoster;
    /**
     * The MemberDirectoryID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $MemberDirectoryID;
    /**
     * The MemberDirectoryTypeID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $MemberDirectoryTypeID;
    /**
     * The MemberID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $MemberID;
    /**
     * The UpdateBy
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UpdateBy;
    /**
     * The UpdateDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UpdateDate;
    /**
     * Constructor method for MemberDirectory
     * @uses MemberDirectory::setConfidentialTypeID()
     * @uses MemberDirectory::setCreateBy()
     * @uses MemberDirectory::setCreateDate()
     * @uses MemberDirectory::setDirectoryData()
     * @uses MemberDirectory::setIsPrimary()
     * @uses MemberDirectory::setIsRoster()
     * @uses MemberDirectory::setMemberDirectoryID()
     * @uses MemberDirectory::setMemberDirectoryTypeID()
     * @uses MemberDirectory::setMemberID()
     * @uses MemberDirectory::setUpdateBy()
     * @uses MemberDirectory::setUpdateDate()
     * @param int $confidentialTypeID
     * @param string $createBy
     * @param string $createDate
     * @param string $directoryData
     * @param bool $isPrimary
     * @param bool $isRoster
     * @param int $memberDirectoryID
     * @param int $memberDirectoryTypeID
     * @param int $memberID
     * @param string $updateBy
     * @param string $updateDate
     */
    public function __construct($confidentialTypeID = null, $createBy = null, $createDate = null, $directoryData = null, $isPrimary = null, $isRoster = null, $memberDirectoryID = null, $memberDirectoryTypeID = null, $memberID = null, $updateBy = null, $updateDate = null)
    {
        $this
            ->setConfidentialTypeID($confidentialTypeID)
            ->setCreateBy($createBy)
            ->setCreateDate($createDate)
            ->setDirectoryData($directoryData)
            ->setIsPrimary($isPrimary)
            ->setIsRoster($isRoster)
            ->setMemberDirectoryID($memberDirectoryID)
            ->setMemberDirectoryTypeID($memberDirectoryTypeID)
            ->setMemberID($memberID)
            ->setUpdateBy($updateBy)
            ->setUpdateDate($updateDate);
    }
    /**
     * Get ConfidentialTypeID value
     * @return int|null
     */
    public function getConfidentialTypeID()
    {
        return $this->ConfidentialTypeID;
    }
    /**
     * Set ConfidentialTypeID value
     * @param int $confidentialTypeID
     * @return \StructType\MemberDirectory
     */
    public function setConfidentialTypeID($confidentialTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($confidentialTypeID) && !(is_int($confidentialTypeID) || ctype_digit($confidentialTypeID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($confidentialTypeID, true), gettype($confidentialTypeID)), __LINE__);
        }
        $this->ConfidentialTypeID = $confidentialTypeID;
        return $this;
    }
    /**
     * Get CreateBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreateBy()
    {
        return isset($this->CreateBy) ? $this->CreateBy : null;
    }
    /**
     * Set CreateBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createBy
     * @return \StructType\MemberDirectory
     */
    public function setCreateBy($createBy = null)
    {
        // validation for constraint: string
        if (!is_null($createBy) && !is_string($createBy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createBy, true), gettype($createBy)), __LINE__);
        }
        if (is_null($createBy) || (is_array($createBy) && empty($createBy))) {
            unset($this->CreateBy);
        } else {
            $this->CreateBy = $createBy;
        }
        return $this;
    }
    /**
     * Get CreateDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreateDate()
    {
        return isset($this->CreateDate) ? $this->CreateDate : null;
    }
    /**
     * Set CreateDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createDate
     * @return \StructType\MemberDirectory
     */
    public function setCreateDate($createDate = null)
    {
        // validation for constraint: string
        if (!is_null($createDate) && !is_string($createDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createDate, true), gettype($createDate)), __LINE__);
        }
        if (is_null($createDate) || (is_array($createDate) && empty($createDate))) {
            unset($this->CreateDate);
        } else {
            $this->CreateDate = $createDate;
        }
        return $this;
    }
    /**
     * Get DirectoryData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDirectoryData()
    {
        return isset($this->DirectoryData) ? $this->DirectoryData : null;
    }
    /**
     * Set DirectoryData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $directoryData
     * @return \StructType\MemberDirectory
     */
    public function setDirectoryData($directoryData = null)
    {
        // validation for constraint: string
        if (!is_null($directoryData) && !is_string($directoryData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($directoryData, true), gettype($directoryData)), __LINE__);
        }
        if (is_null($directoryData) || (is_array($directoryData) && empty($directoryData))) {
            unset($this->DirectoryData);
        } else {
            $this->DirectoryData = $directoryData;
        }
        return $this;
    }
    /**
     * Get IsPrimary value
     * @return bool|null
     */
    public function getIsPrimary()
    {
        return $this->IsPrimary;
    }
    /**
     * Set IsPrimary value
     * @param bool $isPrimary
     * @return \StructType\MemberDirectory
     */
    public function setIsPrimary($isPrimary = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPrimary) && !is_bool($isPrimary)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isPrimary, true), gettype($isPrimary)), __LINE__);
        }
        $this->IsPrimary = $isPrimary;
        return $this;
    }
    /**
     * Get IsRoster value
     * @return bool|null
     */
    public function getIsRoster()
    {
        return $this->IsRoster;
    }
    /**
     * Set IsRoster value
     * @param bool $isRoster
     * @return \StructType\MemberDirectory
     */
    public function setIsRoster($isRoster = null)
    {
        // validation for constraint: boolean
        if (!is_null($isRoster) && !is_bool($isRoster)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isRoster, true), gettype($isRoster)), __LINE__);
        }
        $this->IsRoster = $isRoster;
        return $this;
    }
    /**
     * Get MemberDirectoryID value
     * @return int|null
     */
    public function getMemberDirectoryID()
    {
        return $this->MemberDirectoryID;
    }
    /**
     * Set MemberDirectoryID value
     * @param int $memberDirectoryID
     * @return \StructType\MemberDirectory
     */
    public function setMemberDirectoryID($memberDirectoryID = null)
    {
        // validation for constraint: int
        if (!is_null($memberDirectoryID) && !(is_int($memberDirectoryID) || ctype_digit($memberDirectoryID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($memberDirectoryID, true), gettype($memberDirectoryID)), __LINE__);
        }
        $this->MemberDirectoryID = $memberDirectoryID;
        return $this;
    }
    /**
     * Get MemberDirectoryTypeID value
     * @return int|null
     */
    public function getMemberDirectoryTypeID()
    {
        return $this->MemberDirectoryTypeID;
    }
    /**
     * Set MemberDirectoryTypeID value
     * @param int $memberDirectoryTypeID
     * @return \StructType\MemberDirectory
     */
    public function setMemberDirectoryTypeID($memberDirectoryTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($memberDirectoryTypeID) && !(is_int($memberDirectoryTypeID) || ctype_digit($memberDirectoryTypeID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($memberDirectoryTypeID, true), gettype($memberDirectoryTypeID)), __LINE__);
        }
        $this->MemberDirectoryTypeID = $memberDirectoryTypeID;
        return $this;
    }
    /**
     * Get MemberID value
     * @return int|null
     */
    public function getMemberID()
    {
        return $this->MemberID;
    }
    /**
     * Set MemberID value
     * @param int $memberID
     * @return \StructType\MemberDirectory
     */
    public function setMemberID($memberID = null)
    {
        // validation for constraint: int
        if (!is_null($memberID) && !(is_int($memberID) || ctype_digit($memberID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($memberID, true), gettype($memberID)), __LINE__);
        }
        $this->MemberID = $memberID;
        return $this;
    }
    /**
     * Get UpdateBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUpdateBy()
    {
        return isset($this->UpdateBy) ? $this->UpdateBy : null;
    }
    /**
     * Set UpdateBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $updateBy
     * @return \StructType\MemberDirectory
     */
    public function setUpdateBy($updateBy = null)
    {
        // validation for constraint: string
        if (!is_null($updateBy) && !is_string($updateBy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($updateBy, true), gettype($updateBy)), __LINE__);
        }
        if (is_null($updateBy) || (is_array($updateBy) && empty($updateBy))) {
            unset($this->UpdateBy);
        } else {
            $this->UpdateBy = $updateBy;
        }
        return $this;
    }
    /**
     * Get UpdateDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUpdateDate()
    {
        return isset($this->UpdateDate) ? $this->UpdateDate : null;
    }
    /**
     * Set UpdateDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $updateDate
     * @return \StructType\MemberDirectory
     */
    public function setUpdateDate($updateDate = null)
    {
        // validation for constraint: string
        if (!is_null($updateDate) && !is_string($updateDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($updateDate, true), gettype($updateDate)), __LINE__);
        }
        if (is_null($updateDate) || (is_array($updateDate) && empty($updateDate))) {
            unset($this->UpdateDate);
        } else {
            $this->UpdateDate = $updateDate;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MemberDirectory
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
