<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MemberAddress StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:MemberAddress
 * @subpackage Structs
 */
class MemberAddress extends DbActionBase
{
    /**
     * The AddressLine1
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AddressLine1;
    /**
     * The AddressLine2
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AddressLine2;
    /**
     * The CityName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CityName;
    /**
     * The ConfidentialTypeID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $ConfidentialTypeID;
    /**
     * The CountryID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $CountryID;
    /**
     * The CreateBy
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreateBy;
    /**
     * The CreateDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreateDate;
    /**
     * The IsBadAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsBadAddress;
    /**
     * The IsPrimary
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsPrimary;
    /**
     * The Latitude
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Latitude;
    /**
     * The Longitude
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Longitude;
    /**
     * The MemberAddressID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $MemberAddressID;
    /**
     * The MemberAddressTypeID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $MemberAddressTypeID;
    /**
     * The MemberID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $MemberID;
    /**
     * The ProvinceName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ProvinceName;
    /**
     * The Region
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Region;
    /**
     * The StateID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $StateID;
    /**
     * The UpdateBy
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UpdateBy;
    /**
     * The UpdateDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UpdateDate;
    /**
     * The ZipCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ZipCode;
    /**
     * Constructor method for MemberAddress
     * @uses MemberAddress::setAddressLine1()
     * @uses MemberAddress::setAddressLine2()
     * @uses MemberAddress::setCityName()
     * @uses MemberAddress::setConfidentialTypeID()
     * @uses MemberAddress::setCountryID()
     * @uses MemberAddress::setCreateBy()
     * @uses MemberAddress::setCreateDate()
     * @uses MemberAddress::setIsBadAddress()
     * @uses MemberAddress::setIsPrimary()
     * @uses MemberAddress::setLatitude()
     * @uses MemberAddress::setLongitude()
     * @uses MemberAddress::setMemberAddressID()
     * @uses MemberAddress::setMemberAddressTypeID()
     * @uses MemberAddress::setMemberID()
     * @uses MemberAddress::setProvinceName()
     * @uses MemberAddress::setRegion()
     * @uses MemberAddress::setStateID()
     * @uses MemberAddress::setUpdateBy()
     * @uses MemberAddress::setUpdateDate()
     * @uses MemberAddress::setZipCode()
     * @param string $addressLine1
     * @param string $addressLine2
     * @param string $cityName
     * @param bool $confidentialTypeID
     * @param int $countryID
     * @param string $createBy
     * @param string $createDate
     * @param bool $isBadAddress
     * @param bool $isPrimary
     * @param float $latitude
     * @param float $longitude
     * @param int $memberAddressID
     * @param int $memberAddressTypeID
     * @param int $memberID
     * @param string $provinceName
     * @param string $region
     * @param int $stateID
     * @param string $updateBy
     * @param string $updateDate
     * @param string $zipCode
     */
    public function __construct($addressLine1 = null, $addressLine2 = null, $cityName = null, $confidentialTypeID = null, $countryID = null, $createBy = null, $createDate = null, $isBadAddress = null, $isPrimary = null, $latitude = null, $longitude = null, $memberAddressID = null, $memberAddressTypeID = null, $memberID = null, $provinceName = null, $region = null, $stateID = null, $updateBy = null, $updateDate = null, $zipCode = null)
    {
        $this
            ->setAddressLine1($addressLine1)
            ->setAddressLine2($addressLine2)
            ->setCityName($cityName)
            ->setConfidentialTypeID($confidentialTypeID)
            ->setCountryID($countryID)
            ->setCreateBy($createBy)
            ->setCreateDate($createDate)
            ->setIsBadAddress($isBadAddress)
            ->setIsPrimary($isPrimary)
            ->setLatitude($latitude)
            ->setLongitude($longitude)
            ->setMemberAddressID($memberAddressID)
            ->setMemberAddressTypeID($memberAddressTypeID)
            ->setMemberID($memberID)
            ->setProvinceName($provinceName)
            ->setRegion($region)
            ->setStateID($stateID)
            ->setUpdateBy($updateBy)
            ->setUpdateDate($updateDate)
            ->setZipCode($zipCode);
    }
    /**
     * Get AddressLine1 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAddressLine1()
    {
        return isset($this->AddressLine1) ? $this->AddressLine1 : null;
    }
    /**
     * Set AddressLine1 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $addressLine1
     * @return \StructType\MemberAddress
     */
    public function setAddressLine1($addressLine1 = null)
    {
        // validation for constraint: string
        if (!is_null($addressLine1) && !is_string($addressLine1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($addressLine1, true), gettype($addressLine1)), __LINE__);
        }
        if (is_null($addressLine1) || (is_array($addressLine1) && empty($addressLine1))) {
            unset($this->AddressLine1);
        } else {
            $this->AddressLine1 = $addressLine1;
        }
        return $this;
    }
    /**
     * Get AddressLine2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAddressLine2()
    {
        return isset($this->AddressLine2) ? $this->AddressLine2 : null;
    }
    /**
     * Set AddressLine2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $addressLine2
     * @return \StructType\MemberAddress
     */
    public function setAddressLine2($addressLine2 = null)
    {
        // validation for constraint: string
        if (!is_null($addressLine2) && !is_string($addressLine2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($addressLine2, true), gettype($addressLine2)), __LINE__);
        }
        if (is_null($addressLine2) || (is_array($addressLine2) && empty($addressLine2))) {
            unset($this->AddressLine2);
        } else {
            $this->AddressLine2 = $addressLine2;
        }
        return $this;
    }
    /**
     * Get CityName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCityName()
    {
        return isset($this->CityName) ? $this->CityName : null;
    }
    /**
     * Set CityName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cityName
     * @return \StructType\MemberAddress
     */
    public function setCityName($cityName = null)
    {
        // validation for constraint: string
        if (!is_null($cityName) && !is_string($cityName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cityName, true), gettype($cityName)), __LINE__);
        }
        if (is_null($cityName) || (is_array($cityName) && empty($cityName))) {
            unset($this->CityName);
        } else {
            $this->CityName = $cityName;
        }
        return $this;
    }
    /**
     * Get ConfidentialTypeID value
     * @return bool|null
     */
    public function getConfidentialTypeID()
    {
        return $this->ConfidentialTypeID;
    }
    /**
     * Set ConfidentialTypeID value
     * @param bool $confidentialTypeID
     * @return \StructType\MemberAddress
     */
    public function setConfidentialTypeID($confidentialTypeID = null)
    {
        // validation for constraint: boolean
        if (!is_null($confidentialTypeID) && !is_bool($confidentialTypeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($confidentialTypeID, true), gettype($confidentialTypeID)), __LINE__);
        }
        $this->ConfidentialTypeID = $confidentialTypeID;
        return $this;
    }
    /**
     * Get CountryID value
     * @return int|null
     */
    public function getCountryID()
    {
        return $this->CountryID;
    }
    /**
     * Set CountryID value
     * @param int $countryID
     * @return \StructType\MemberAddress
     */
    public function setCountryID($countryID = null)
    {
        // validation for constraint: int
        if (!is_null($countryID) && !(is_int($countryID) || ctype_digit($countryID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($countryID, true), gettype($countryID)), __LINE__);
        }
        $this->CountryID = $countryID;
        return $this;
    }
    /**
     * Get CreateBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreateBy()
    {
        return isset($this->CreateBy) ? $this->CreateBy : null;
    }
    /**
     * Set CreateBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createBy
     * @return \StructType\MemberAddress
     */
    public function setCreateBy($createBy = null)
    {
        // validation for constraint: string
        if (!is_null($createBy) && !is_string($createBy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createBy, true), gettype($createBy)), __LINE__);
        }
        if (is_null($createBy) || (is_array($createBy) && empty($createBy))) {
            unset($this->CreateBy);
        } else {
            $this->CreateBy = $createBy;
        }
        return $this;
    }
    /**
     * Get CreateDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreateDate()
    {
        return isset($this->CreateDate) ? $this->CreateDate : null;
    }
    /**
     * Set CreateDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createDate
     * @return \StructType\MemberAddress
     */
    public function setCreateDate($createDate = null)
    {
        // validation for constraint: string
        if (!is_null($createDate) && !is_string($createDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createDate, true), gettype($createDate)), __LINE__);
        }
        if (is_null($createDate) || (is_array($createDate) && empty($createDate))) {
            unset($this->CreateDate);
        } else {
            $this->CreateDate = $createDate;
        }
        return $this;
    }
    /**
     * Get IsBadAddress value
     * @return bool|null
     */
    public function getIsBadAddress()
    {
        return $this->IsBadAddress;
    }
    /**
     * Set IsBadAddress value
     * @param bool $isBadAddress
     * @return \StructType\MemberAddress
     */
    public function setIsBadAddress($isBadAddress = null)
    {
        // validation for constraint: boolean
        if (!is_null($isBadAddress) && !is_bool($isBadAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isBadAddress, true), gettype($isBadAddress)), __LINE__);
        }
        $this->IsBadAddress = $isBadAddress;
        return $this;
    }
    /**
     * Get IsPrimary value
     * @return bool|null
     */
    public function getIsPrimary()
    {
        return $this->IsPrimary;
    }
    /**
     * Set IsPrimary value
     * @param bool $isPrimary
     * @return \StructType\MemberAddress
     */
    public function setIsPrimary($isPrimary = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPrimary) && !is_bool($isPrimary)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isPrimary, true), gettype($isPrimary)), __LINE__);
        }
        $this->IsPrimary = $isPrimary;
        return $this;
    }
    /**
     * Get Latitude value
     * @return float|null
     */
    public function getLatitude()
    {
        return $this->Latitude;
    }
    /**
     * Set Latitude value
     * @param float $latitude
     * @return \StructType\MemberAddress
     */
    public function setLatitude($latitude = null)
    {
        // validation for constraint: float
        if (!is_null($latitude) && !(is_float($latitude) || is_numeric($latitude))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($latitude, true), gettype($latitude)), __LINE__);
        }
        $this->Latitude = $latitude;
        return $this;
    }
    /**
     * Get Longitude value
     * @return float|null
     */
    public function getLongitude()
    {
        return $this->Longitude;
    }
    /**
     * Set Longitude value
     * @param float $longitude
     * @return \StructType\MemberAddress
     */
    public function setLongitude($longitude = null)
    {
        // validation for constraint: float
        if (!is_null($longitude) && !(is_float($longitude) || is_numeric($longitude))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($longitude, true), gettype($longitude)), __LINE__);
        }
        $this->Longitude = $longitude;
        return $this;
    }
    /**
     * Get MemberAddressID value
     * @return int|null
     */
    public function getMemberAddressID()
    {
        return $this->MemberAddressID;
    }
    /**
     * Set MemberAddressID value
     * @param int $memberAddressID
     * @return \StructType\MemberAddress
     */
    public function setMemberAddressID($memberAddressID = null)
    {
        // validation for constraint: int
        if (!is_null($memberAddressID) && !(is_int($memberAddressID) || ctype_digit($memberAddressID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($memberAddressID, true), gettype($memberAddressID)), __LINE__);
        }
        $this->MemberAddressID = $memberAddressID;
        return $this;
    }
    /**
     * Get MemberAddressTypeID value
     * @return int|null
     */
    public function getMemberAddressTypeID()
    {
        return $this->MemberAddressTypeID;
    }
    /**
     * Set MemberAddressTypeID value
     * @param int $memberAddressTypeID
     * @return \StructType\MemberAddress
     */
    public function setMemberAddressTypeID($memberAddressTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($memberAddressTypeID) && !(is_int($memberAddressTypeID) || ctype_digit($memberAddressTypeID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($memberAddressTypeID, true), gettype($memberAddressTypeID)), __LINE__);
        }
        $this->MemberAddressTypeID = $memberAddressTypeID;
        return $this;
    }
    /**
     * Get MemberID value
     * @return int|null
     */
    public function getMemberID()
    {
        return $this->MemberID;
    }
    /**
     * Set MemberID value
     * @param int $memberID
     * @return \StructType\MemberAddress
     */
    public function setMemberID($memberID = null)
    {
        // validation for constraint: int
        if (!is_null($memberID) && !(is_int($memberID) || ctype_digit($memberID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($memberID, true), gettype($memberID)), __LINE__);
        }
        $this->MemberID = $memberID;
        return $this;
    }
    /**
     * Get ProvinceName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProvinceName()
    {
        return isset($this->ProvinceName) ? $this->ProvinceName : null;
    }
    /**
     * Set ProvinceName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $provinceName
     * @return \StructType\MemberAddress
     */
    public function setProvinceName($provinceName = null)
    {
        // validation for constraint: string
        if (!is_null($provinceName) && !is_string($provinceName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($provinceName, true), gettype($provinceName)), __LINE__);
        }
        if (is_null($provinceName) || (is_array($provinceName) && empty($provinceName))) {
            unset($this->ProvinceName);
        } else {
            $this->ProvinceName = $provinceName;
        }
        return $this;
    }
    /**
     * Get Region value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRegion()
    {
        return isset($this->Region) ? $this->Region : null;
    }
    /**
     * Set Region value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $region
     * @return \StructType\MemberAddress
     */
    public function setRegion($region = null)
    {
        // validation for constraint: string
        if (!is_null($region) && !is_string($region)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($region, true), gettype($region)), __LINE__);
        }
        if (is_null($region) || (is_array($region) && empty($region))) {
            unset($this->Region);
        } else {
            $this->Region = $region;
        }
        return $this;
    }
    /**
     * Get StateID value
     * @return int|null
     */
    public function getStateID()
    {
        return $this->StateID;
    }
    /**
     * Set StateID value
     * @param int $stateID
     * @return \StructType\MemberAddress
     */
    public function setStateID($stateID = null)
    {
        // validation for constraint: int
        if (!is_null($stateID) && !(is_int($stateID) || ctype_digit($stateID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($stateID, true), gettype($stateID)), __LINE__);
        }
        $this->StateID = $stateID;
        return $this;
    }
    /**
     * Get UpdateBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUpdateBy()
    {
        return isset($this->UpdateBy) ? $this->UpdateBy : null;
    }
    /**
     * Set UpdateBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $updateBy
     * @return \StructType\MemberAddress
     */
    public function setUpdateBy($updateBy = null)
    {
        // validation for constraint: string
        if (!is_null($updateBy) && !is_string($updateBy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($updateBy, true), gettype($updateBy)), __LINE__);
        }
        if (is_null($updateBy) || (is_array($updateBy) && empty($updateBy))) {
            unset($this->UpdateBy);
        } else {
            $this->UpdateBy = $updateBy;
        }
        return $this;
    }
    /**
     * Get UpdateDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUpdateDate()
    {
        return isset($this->UpdateDate) ? $this->UpdateDate : null;
    }
    /**
     * Set UpdateDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $updateDate
     * @return \StructType\MemberAddress
     */
    public function setUpdateDate($updateDate = null)
    {
        // validation for constraint: string
        if (!is_null($updateDate) && !is_string($updateDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($updateDate, true), gettype($updateDate)), __LINE__);
        }
        if (is_null($updateDate) || (is_array($updateDate) && empty($updateDate))) {
            unset($this->UpdateDate);
        } else {
            $this->UpdateDate = $updateDate;
        }
        return $this;
    }
    /**
     * Get ZipCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getZipCode()
    {
        return isset($this->ZipCode) ? $this->ZipCode : null;
    }
    /**
     * Set ZipCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $zipCode
     * @return \StructType\MemberAddress
     */
    public function setZipCode($zipCode = null)
    {
        // validation for constraint: string
        if (!is_null($zipCode) && !is_string($zipCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($zipCode, true), gettype($zipCode)), __LINE__);
        }
        if (is_null($zipCode) || (is_array($zipCode) && empty($zipCode))) {
            unset($this->ZipCode);
        } else {
            $this->ZipCode = $zipCode;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MemberAddress
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
