<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfMemberPackage ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfMemberPackage
 * @subpackage Arrays
 */
class ArrayOfMemberPackage extends AbstractStructArrayBase
{
    /**
     * The MemberPackage
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\MemberPackage[]
     */
    public $MemberPackage;
    /**
     * Constructor method for ArrayOfMemberPackage
     * @uses ArrayOfMemberPackage::setMemberPackage()
     * @param \StructType\MemberPackage[] $memberPackage
     */
    public function __construct(array $memberPackage = array())
    {
        $this
            ->setMemberPackage($memberPackage);
    }
    /**
     * Get MemberPackage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\MemberPackage[]|null
     */
    public function getMemberPackage()
    {
        return isset($this->MemberPackage) ? $this->MemberPackage : null;
    }
    /**
     * This method is responsible for validating the values passed to the setMemberPackage method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMemberPackage method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMemberPackageForArrayConstraintsFromSetMemberPackage(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfMemberPackageMemberPackageItem) {
            // validation for constraint: itemType
            if (!$arrayOfMemberPackageMemberPackageItem instanceof \StructType\MemberPackage) {
                $invalidValues[] = is_object($arrayOfMemberPackageMemberPackageItem) ? get_class($arrayOfMemberPackageMemberPackageItem) : sprintf('%s(%s)', gettype($arrayOfMemberPackageMemberPackageItem), var_export($arrayOfMemberPackageMemberPackageItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The MemberPackage property can only contain items of type \StructType\MemberPackage, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set MemberPackage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\MemberPackage[] $memberPackage
     * @return \ArrayType\ArrayOfMemberPackage
     */
    public function setMemberPackage(array $memberPackage = array())
    {
        // validation for constraint: array
        if ('' !== ($memberPackageArrayErrorMessage = self::validateMemberPackageForArrayConstraintsFromSetMemberPackage($memberPackage))) {
            throw new \InvalidArgumentException($memberPackageArrayErrorMessage, __LINE__);
        }
        if (is_null($memberPackage) || (is_array($memberPackage) && empty($memberPackage))) {
            unset($this->MemberPackage);
        } else {
            $this->MemberPackage = $memberPackage;
        }
        return $this;
    }
    /**
     * Add item to MemberPackage value
     * @throws \InvalidArgumentException
     * @param \StructType\MemberPackage $item
     * @return \ArrayType\ArrayOfMemberPackage
     */
    public function addToMemberPackage(\StructType\MemberPackage $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\MemberPackage) {
            throw new \InvalidArgumentException(sprintf('The MemberPackage property can only contain items of type \StructType\MemberPackage, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->MemberPackage[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\MemberPackage|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\MemberPackage|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\MemberPackage|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\MemberPackage|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\MemberPackage|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string MemberPackage
     */
    public function getAttributeName()
    {
        return 'MemberPackage';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfMemberPackage
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
