<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReportWorkByMember StructType
 * @subpackage Structs
 */
class ReportWorkByMember extends AbstractStructBase
{
    /**
     * The webServiceCredentials
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ServiceCredential
     */
    public $webServiceCredentials;
    /**
     * The memberid
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $memberid;
    /**
     * Constructor method for ReportWorkByMember
     * @uses ReportWorkByMember::setWebServiceCredentials()
     * @uses ReportWorkByMember::setMemberid()
     * @param \StructType\ServiceCredential $webServiceCredentials
     * @param int $memberid
     */
    public function __construct(\StructType\ServiceCredential $webServiceCredentials = null, $memberid = null)
    {
        $this
            ->setWebServiceCredentials($webServiceCredentials)
            ->setMemberid($memberid);
    }
    /**
     * Get webServiceCredentials value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ServiceCredential|null
     */
    public function getWebServiceCredentials()
    {
        return isset($this->webServiceCredentials) ? $this->webServiceCredentials : null;
    }
    /**
     * Set webServiceCredentials value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ServiceCredential $webServiceCredentials
     * @return \StructType\ReportWorkByMember
     */
    public function setWebServiceCredentials(\StructType\ServiceCredential $webServiceCredentials = null)
    {
        if (is_null($webServiceCredentials) || (is_array($webServiceCredentials) && empty($webServiceCredentials))) {
            unset($this->webServiceCredentials);
        } else {
            $this->webServiceCredentials = $webServiceCredentials;
        }
        return $this;
    }
    /**
     * Get memberid value
     * @return int|null
     */
    public function getMemberid()
    {
        return $this->memberid;
    }
    /**
     * Set memberid value
     * @param int $memberid
     * @return \StructType\ReportWorkByMember
     */
    public function setMemberid($memberid = null)
    {
        // validation for constraint: int
        if (!is_null($memberid) && !(is_int($memberid) || ctype_digit($memberid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($memberid, true), gettype($memberid)), __LINE__);
        }
        $this->memberid = $memberid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ReportWorkByMember
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
