<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Report ServiceType
 * @subpackage Services
 */
class Report extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ReportWorkInsert
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ReportWorkInsert $parameters
     * @return \StructType\ReportWorkInsertResponse|bool
     */
    public function ReportWorkInsert(\StructType\ReportWorkInsert $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ReportWorkInsert($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ReportWorkUpdate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ReportWorkUpdate $parameters
     * @return \StructType\ReportWorkUpdateResponse|bool
     */
    public function ReportWorkUpdate(\StructType\ReportWorkUpdate $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ReportWorkUpdate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ReportWorkDelete
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ReportWorkDelete $parameters
     * @return \StructType\ReportWorkDeleteResponse|bool
     */
    public function ReportWorkDelete(\StructType\ReportWorkDelete $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ReportWorkDelete($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ReportWorkByMember
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ReportWorkByMember $parameters
     * @return \StructType\ReportWorkByMemberResponse|bool
     */
    public function ReportWorkByMember(\StructType\ReportWorkByMember $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ReportWorkByMember($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ReportWorkByMemberResponse|\StructType\ReportWorkDeleteResponse|\StructType\ReportWorkInsertResponse|\StructType\ReportWorkUpdateResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
