<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SalesOrderItem StructType
 * @subpackage Structs
 */
class SalesOrderItem extends AbstractStructBase
{
    /**
     * The actualPrice
     * @var string
     */
    public $actualPrice;
    /**
     * The color
     * @var string
     */
    public $color;
    /**
     * The extAmount
     * @var string
     */
    public $extAmount;
    /**
     * The itemCost
     * @var string
     */
    public $itemCost;
    /**
     * The lineNumber
     * @var string
     */
    public $lineNumber;
    /**
     * The model
     * @var string
     */
    public $model;
    /**
     * The productDescription
     * @var string
     */
    public $productDescription;
    /**
     * The productNumber
     * @var string
     */
    public $productNumber;
    /**
     * The quantity
     * @var string
     */
    public $quantity;
    /**
     * The rawMaterial
     * @var string
     */
    public $rawMaterial;
    /**
     * The configuration
     * Meta information extracted from the WSDL
     * - arrayType: tns:Configuration[]
     * - base: soap-enc:Array
     * - ref: soap-enc:arrayType
     * @var \StructType\Configuration[]
     */
    public $configuration;
    /**
     * Constructor method for SalesOrderItem
     * @uses SalesOrderItem::setActualPrice()
     * @uses SalesOrderItem::setColor()
     * @uses SalesOrderItem::setExtAmount()
     * @uses SalesOrderItem::setItemCost()
     * @uses SalesOrderItem::setLineNumber()
     * @uses SalesOrderItem::setModel()
     * @uses SalesOrderItem::setProductDescription()
     * @uses SalesOrderItem::setProductNumber()
     * @uses SalesOrderItem::setQuantity()
     * @uses SalesOrderItem::setRawMaterial()
     * @uses SalesOrderItem::setConfiguration()
     * @param string $actualPrice
     * @param string $color
     * @param string $extAmount
     * @param string $itemCost
     * @param string $lineNumber
     * @param string $model
     * @param string $productDescription
     * @param string $productNumber
     * @param string $quantity
     * @param string $rawMaterial
     * @param \StructType\Configuration[] $configuration
     */
    public function __construct($actualPrice = null, $color = null, $extAmount = null, $itemCost = null, $lineNumber = null, $model = null, $productDescription = null, $productNumber = null, $quantity = null, $rawMaterial = null, array $configuration = array())
    {
        $this
            ->setActualPrice($actualPrice)
            ->setColor($color)
            ->setExtAmount($extAmount)
            ->setItemCost($itemCost)
            ->setLineNumber($lineNumber)
            ->setModel($model)
            ->setProductDescription($productDescription)
            ->setProductNumber($productNumber)
            ->setQuantity($quantity)
            ->setRawMaterial($rawMaterial)
            ->setConfiguration($configuration);
    }
    /**
     * Get actualPrice value
     * @return string|null
     */
    public function getActualPrice()
    {
        return $this->actualPrice;
    }
    /**
     * Set actualPrice value
     * @param string $actualPrice
     * @return \StructType\SalesOrderItem
     */
    public function setActualPrice($actualPrice = null)
    {
        // validation for constraint: string
        if (!is_null($actualPrice) && !is_string($actualPrice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($actualPrice, true), gettype($actualPrice)), __LINE__);
        }
        $this->actualPrice = $actualPrice;
        return $this;
    }
    /**
     * Get color value
     * @return string|null
     */
    public function getColor()
    {
        return $this->color;
    }
    /**
     * Set color value
     * @param string $color
     * @return \StructType\SalesOrderItem
     */
    public function setColor($color = null)
    {
        // validation for constraint: string
        if (!is_null($color) && !is_string($color)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($color, true), gettype($color)), __LINE__);
        }
        $this->color = $color;
        return $this;
    }
    /**
     * Get extAmount value
     * @return string|null
     */
    public function getExtAmount()
    {
        return $this->extAmount;
    }
    /**
     * Set extAmount value
     * @param string $extAmount
     * @return \StructType\SalesOrderItem
     */
    public function setExtAmount($extAmount = null)
    {
        // validation for constraint: string
        if (!is_null($extAmount) && !is_string($extAmount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extAmount, true), gettype($extAmount)), __LINE__);
        }
        $this->extAmount = $extAmount;
        return $this;
    }
    /**
     * Get itemCost value
     * @return string|null
     */
    public function getItemCost()
    {
        return $this->itemCost;
    }
    /**
     * Set itemCost value
     * @param string $itemCost
     * @return \StructType\SalesOrderItem
     */
    public function setItemCost($itemCost = null)
    {
        // validation for constraint: string
        if (!is_null($itemCost) && !is_string($itemCost)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemCost, true), gettype($itemCost)), __LINE__);
        }
        $this->itemCost = $itemCost;
        return $this;
    }
    /**
     * Get lineNumber value
     * @return string|null
     */
    public function getLineNumber()
    {
        return $this->lineNumber;
    }
    /**
     * Set lineNumber value
     * @param string $lineNumber
     * @return \StructType\SalesOrderItem
     */
    public function setLineNumber($lineNumber = null)
    {
        // validation for constraint: string
        if (!is_null($lineNumber) && !is_string($lineNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lineNumber, true), gettype($lineNumber)), __LINE__);
        }
        $this->lineNumber = $lineNumber;
        return $this;
    }
    /**
     * Get model value
     * @return string|null
     */
    public function getModel()
    {
        return $this->model;
    }
    /**
     * Set model value
     * @param string $model
     * @return \StructType\SalesOrderItem
     */
    public function setModel($model = null)
    {
        // validation for constraint: string
        if (!is_null($model) && !is_string($model)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($model, true), gettype($model)), __LINE__);
        }
        $this->model = $model;
        return $this;
    }
    /**
     * Get productDescription value
     * @return string|null
     */
    public function getProductDescription()
    {
        return $this->productDescription;
    }
    /**
     * Set productDescription value
     * @param string $productDescription
     * @return \StructType\SalesOrderItem
     */
    public function setProductDescription($productDescription = null)
    {
        // validation for constraint: string
        if (!is_null($productDescription) && !is_string($productDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productDescription, true), gettype($productDescription)), __LINE__);
        }
        $this->productDescription = $productDescription;
        return $this;
    }
    /**
     * Get productNumber value
     * @return string|null
     */
    public function getProductNumber()
    {
        return $this->productNumber;
    }
    /**
     * Set productNumber value
     * @param string $productNumber
     * @return \StructType\SalesOrderItem
     */
    public function setProductNumber($productNumber = null)
    {
        // validation for constraint: string
        if (!is_null($productNumber) && !is_string($productNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productNumber, true), gettype($productNumber)), __LINE__);
        }
        $this->productNumber = $productNumber;
        return $this;
    }
    /**
     * Get quantity value
     * @return string|null
     */
    public function getQuantity()
    {
        return $this->quantity;
    }
    /**
     * Set quantity value
     * @param string $quantity
     * @return \StructType\SalesOrderItem
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: string
        if (!is_null($quantity) && !is_string($quantity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->quantity = $quantity;
        return $this;
    }
    /**
     * Get rawMaterial value
     * @return string|null
     */
    public function getRawMaterial()
    {
        return $this->rawMaterial;
    }
    /**
     * Set rawMaterial value
     * @param string $rawMaterial
     * @return \StructType\SalesOrderItem
     */
    public function setRawMaterial($rawMaterial = null)
    {
        // validation for constraint: string
        if (!is_null($rawMaterial) && !is_string($rawMaterial)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rawMaterial, true), gettype($rawMaterial)), __LINE__);
        }
        $this->rawMaterial = $rawMaterial;
        return $this;
    }
    /**
     * Get configuration value
     * @return \StructType\Configuration[]|null
     */
    public function getConfiguration()
    {
        return $this->configuration;
    }
    /**
     * This method is responsible for validating the values passed to the setConfiguration method
     * This method is willingly generated in order to preserve the one-line inline validation within the setConfiguration method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateConfigurationForArrayConstraintsFromSetConfiguration(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $salesOrderItemConfigurationItem) {
            // validation for constraint: itemType
            if (!$salesOrderItemConfigurationItem instanceof \StructType\Configuration) {
                $invalidValues[] = is_object($salesOrderItemConfigurationItem) ? get_class($salesOrderItemConfigurationItem) : sprintf('%s(%s)', gettype($salesOrderItemConfigurationItem), var_export($salesOrderItemConfigurationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The configuration property can only contain items of type \StructType\Configuration, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set configuration value
     * @throws \InvalidArgumentException
     * @param \StructType\Configuration[] $configuration
     * @return \StructType\SalesOrderItem
     */
    public function setConfiguration(array $configuration = array())
    {
        // validation for constraint: array
        if ('' !== ($configurationArrayErrorMessage = self::validateConfigurationForArrayConstraintsFromSetConfiguration($configuration))) {
            throw new \InvalidArgumentException($configurationArrayErrorMessage, __LINE__);
        }
        $this->configuration = $configuration;
        return $this;
    }
    /**
     * Add item to configuration value
     * @throws \InvalidArgumentException
     * @param \StructType\Configuration $item
     * @return \StructType\SalesOrderItem
     */
    public function addToConfiguration(\StructType\Configuration $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Configuration) {
            throw new \InvalidArgumentException(sprintf('The configuration property can only contain items of type \StructType\Configuration, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->configuration[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SalesOrderItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
