<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SalesOrderAddress StructType
 * @subpackage Structs
 */
class SalesOrderAddress extends AbstractStructBase
{
    /**
     * The address1
     * @var string
     */
    public $address1;
    /**
     * The address2
     * @var string
     */
    public $address2;
    /**
     * The address3
     * @var string
     */
    public $address3;
    /**
     * The zip
     * @var string
     */
    public $zip;
    /**
     * The zipFourCode
     * @var string
     */
    public $zipFourCode;
    /**
     * The city
     * @var string
     */
    public $city;
    /**
     * The state
     * @var string
     */
    public $state;
    /**
     * The country
     * @var string
     */
    public $country;
    /**
     * The attentionTo
     * @var string
     */
    public $attentionTo;
    /**
     * Constructor method for SalesOrderAddress
     * @uses SalesOrderAddress::setAddress1()
     * @uses SalesOrderAddress::setAddress2()
     * @uses SalesOrderAddress::setAddress3()
     * @uses SalesOrderAddress::setZip()
     * @uses SalesOrderAddress::setZipFourCode()
     * @uses SalesOrderAddress::setCity()
     * @uses SalesOrderAddress::setState()
     * @uses SalesOrderAddress::setCountry()
     * @uses SalesOrderAddress::setAttentionTo()
     * @param string $address1
     * @param string $address2
     * @param string $address3
     * @param string $zip
     * @param string $zipFourCode
     * @param string $city
     * @param string $state
     * @param string $country
     * @param string $attentionTo
     */
    public function __construct($address1 = null, $address2 = null, $address3 = null, $zip = null, $zipFourCode = null, $city = null, $state = null, $country = null, $attentionTo = null)
    {
        $this
            ->setAddress1($address1)
            ->setAddress2($address2)
            ->setAddress3($address3)
            ->setZip($zip)
            ->setZipFourCode($zipFourCode)
            ->setCity($city)
            ->setState($state)
            ->setCountry($country)
            ->setAttentionTo($attentionTo);
    }
    /**
     * Get address1 value
     * @return string|null
     */
    public function getAddress1()
    {
        return $this->address1;
    }
    /**
     * Set address1 value
     * @param string $address1
     * @return \StructType\SalesOrderAddress
     */
    public function setAddress1($address1 = null)
    {
        // validation for constraint: string
        if (!is_null($address1) && !is_string($address1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($address1, true), gettype($address1)), __LINE__);
        }
        $this->address1 = $address1;
        return $this;
    }
    /**
     * Get address2 value
     * @return string|null
     */
    public function getAddress2()
    {
        return $this->address2;
    }
    /**
     * Set address2 value
     * @param string $address2
     * @return \StructType\SalesOrderAddress
     */
    public function setAddress2($address2 = null)
    {
        // validation for constraint: string
        if (!is_null($address2) && !is_string($address2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($address2, true), gettype($address2)), __LINE__);
        }
        $this->address2 = $address2;
        return $this;
    }
    /**
     * Get address3 value
     * @return string|null
     */
    public function getAddress3()
    {
        return $this->address3;
    }
    /**
     * Set address3 value
     * @param string $address3
     * @return \StructType\SalesOrderAddress
     */
    public function setAddress3($address3 = null)
    {
        // validation for constraint: string
        if (!is_null($address3) && !is_string($address3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($address3, true), gettype($address3)), __LINE__);
        }
        $this->address3 = $address3;
        return $this;
    }
    /**
     * Get zip value
     * @return string|null
     */
    public function getZip()
    {
        return $this->zip;
    }
    /**
     * Set zip value
     * @param string $zip
     * @return \StructType\SalesOrderAddress
     */
    public function setZip($zip = null)
    {
        // validation for constraint: string
        if (!is_null($zip) && !is_string($zip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($zip, true), gettype($zip)), __LINE__);
        }
        $this->zip = $zip;
        return $this;
    }
    /**
     * Get zipFourCode value
     * @return string|null
     */
    public function getZipFourCode()
    {
        return $this->zipFourCode;
    }
    /**
     * Set zipFourCode value
     * @param string $zipFourCode
     * @return \StructType\SalesOrderAddress
     */
    public function setZipFourCode($zipFourCode = null)
    {
        // validation for constraint: string
        if (!is_null($zipFourCode) && !is_string($zipFourCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($zipFourCode, true), gettype($zipFourCode)), __LINE__);
        }
        $this->zipFourCode = $zipFourCode;
        return $this;
    }
    /**
     * Get city value
     * @return string|null
     */
    public function getCity()
    {
        return $this->city;
    }
    /**
     * Set city value
     * @param string $city
     * @return \StructType\SalesOrderAddress
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($city, true), gettype($city)), __LINE__);
        }
        $this->city = $city;
        return $this;
    }
    /**
     * Get state value
     * @return string|null
     */
    public function getState()
    {
        return $this->state;
    }
    /**
     * Set state value
     * @param string $state
     * @return \StructType\SalesOrderAddress
     */
    public function setState($state = null)
    {
        // validation for constraint: string
        if (!is_null($state) && !is_string($state)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($state, true), gettype($state)), __LINE__);
        }
        $this->state = $state;
        return $this;
    }
    /**
     * Get country value
     * @return string|null
     */
    public function getCountry()
    {
        return $this->country;
    }
    /**
     * Set country value
     * @param string $country
     * @return \StructType\SalesOrderAddress
     */
    public function setCountry($country = null)
    {
        // validation for constraint: string
        if (!is_null($country) && !is_string($country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($country, true), gettype($country)), __LINE__);
        }
        $this->country = $country;
        return $this;
    }
    /**
     * Get attentionTo value
     * @return string|null
     */
    public function getAttentionTo()
    {
        return $this->attentionTo;
    }
    /**
     * Set attentionTo value
     * @param string $attentionTo
     * @return \StructType\SalesOrderAddress
     */
    public function setAttentionTo($attentionTo = null)
    {
        // validation for constraint: string
        if (!is_null($attentionTo) && !is_string($attentionTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($attentionTo, true), gettype($attentionTo)), __LINE__);
        }
        $this->attentionTo = $attentionTo;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SalesOrderAddress
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
