<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Configuration StructType
 * @subpackage Structs
 */
class Configuration extends AbstractStructBase
{
    /**
     * The segment
     * @var string
     */
    public $segment;
    /**
     * The value
     * @var string
     */
    public $value;
    /**
     * Constructor method for Configuration
     * @uses Configuration::setSegment()
     * @uses Configuration::setValue()
     * @param string $segment
     * @param string $value
     */
    public function __construct($segment = null, $value = null)
    {
        $this
            ->setSegment($segment)
            ->setValue($value);
    }
    /**
     * Get segment value
     * @return string|null
     */
    public function getSegment()
    {
        return $this->segment;
    }
    /**
     * Set segment value
     * @param string $segment
     * @return \StructType\Configuration
     */
    public function setSegment($segment = null)
    {
        // validation for constraint: string
        if (!is_null($segment) && !is_string($segment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($segment, true), gettype($segment)), __LINE__);
        }
        $this->segment = $segment;
        return $this;
    }
    /**
     * Get value value
     * @return string|null
     */
    public function getValue()
    {
        return $this->value;
    }
    /**
     * Set value value
     * @param string $value
     * @return \StructType\Configuration
     */
    public function setValue($value = null)
    {
        // validation for constraint: string
        if (!is_null($value) && !is_string($value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($value, true), gettype($value)), __LINE__);
        }
        $this->value = $value;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Configuration
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
