<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named getHitOrdersFromPoNumber
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $customerNumber
     * @param string $userCredential
     * @param string $poNumber
     * @return \StructType\HitOrder[]|bool
     */
    public function getHitOrdersFromPoNumber($customerNumber, $userCredential, $poNumber)
    {
        try {
            $this->setResult($this->getSoapClient()->getHitOrdersFromPoNumber($customerNumber, $userCredential, $poNumber));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getProductsPerHitOrder
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $customerNumber
     * @param string $userCredential
     * @param string $hitOrderNumber
     * @return \StructType\HitOrderDetail[]|bool
     */
    public function getProductsPerHitOrder($customerNumber, $userCredential, $hitOrderNumber)
    {
        try {
            $this->setResult($this->getSoapClient()->getProductsPerHitOrder($customerNumber, $userCredential, $hitOrderNumber));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getSalesOrderData
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $customerNumber
     * @param string $userCredential
     * @param string $hitOrderNumber
     * @return \StructType\SalesOrderData|bool
     */
    public function getSalesOrderData($customerNumber, $userCredential, $hitOrderNumber)
    {
        try {
            $this->setResult($this->getSoapClient()->getSalesOrderData($customerNumber, $userCredential, $hitOrderNumber));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\HitOrderDetail[]|\StructType\HitOrder[]|\StructType\SalesOrderData
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
