<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SalesOrderData StructType
 * @subpackage Structs
 */
class SalesOrderData extends AbstractStructBase
{
    /**
     * The warehouse
     * @var string
     */
    public $warehouse;
    /**
     * The requiredDate
     * @var string
     */
    public $requiredDate;
    /**
     * The salesOrderTotal
     * @var string
     */
    public $salesOrderTotal;
    /**
     * The address
     * @var \StructType\SalesOrderAddress
     */
    public $address;
    /**
     * The items
     * Meta information extracted from the WSDL
     * - arrayType: tns:SalesOrderItem[]
     * - base: soap-enc:Array
     * - ref: soap-enc:arrayType
     * @var \StructType\SalesOrderItem[]
     */
    public $items;
    /**
     * The customerNumber
     * @var string
     */
    public $customerNumber;
    /**
     * The hitOrderNumber
     * @var string
     */
    public $hitOrderNumber;
    /**
     * The hitOrderSuffix
     * @var string
     */
    public $hitOrderSuffix;
    /**
     * The purchaseOrderNumber
     * @var string
     */
    public $purchaseOrderNumber;
    /**
     * The isBackOrder
     * @var bool
     */
    public $isBackOrder;
    /**
     * Constructor method for SalesOrderData
     * @uses SalesOrderData::setWarehouse()
     * @uses SalesOrderData::setRequiredDate()
     * @uses SalesOrderData::setSalesOrderTotal()
     * @uses SalesOrderData::setAddress()
     * @uses SalesOrderData::setItems()
     * @uses SalesOrderData::setCustomerNumber()
     * @uses SalesOrderData::setHitOrderNumber()
     * @uses SalesOrderData::setHitOrderSuffix()
     * @uses SalesOrderData::setPurchaseOrderNumber()
     * @uses SalesOrderData::setIsBackOrder()
     * @param string $warehouse
     * @param string $requiredDate
     * @param string $salesOrderTotal
     * @param \StructType\SalesOrderAddress $address
     * @param \StructType\SalesOrderItem[] $items
     * @param string $customerNumber
     * @param string $hitOrderNumber
     * @param string $hitOrderSuffix
     * @param string $purchaseOrderNumber
     * @param bool $isBackOrder
     */
    public function __construct($warehouse = null, $requiredDate = null, $salesOrderTotal = null, \StructType\SalesOrderAddress $address = null, array $items = array(), $customerNumber = null, $hitOrderNumber = null, $hitOrderSuffix = null, $purchaseOrderNumber = null, $isBackOrder = null)
    {
        $this
            ->setWarehouse($warehouse)
            ->setRequiredDate($requiredDate)
            ->setSalesOrderTotal($salesOrderTotal)
            ->setAddress($address)
            ->setItems($items)
            ->setCustomerNumber($customerNumber)
            ->setHitOrderNumber($hitOrderNumber)
            ->setHitOrderSuffix($hitOrderSuffix)
            ->setPurchaseOrderNumber($purchaseOrderNumber)
            ->setIsBackOrder($isBackOrder);
    }
    /**
     * Get warehouse value
     * @return string|null
     */
    public function getWarehouse()
    {
        return $this->warehouse;
    }
    /**
     * Set warehouse value
     * @param string $warehouse
     * @return \StructType\SalesOrderData
     */
    public function setWarehouse($warehouse = null)
    {
        // validation for constraint: string
        if (!is_null($warehouse) && !is_string($warehouse)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($warehouse, true), gettype($warehouse)), __LINE__);
        }
        $this->warehouse = $warehouse;
        return $this;
    }
    /**
     * Get requiredDate value
     * @return string|null
     */
    public function getRequiredDate()
    {
        return $this->requiredDate;
    }
    /**
     * Set requiredDate value
     * @param string $requiredDate
     * @return \StructType\SalesOrderData
     */
    public function setRequiredDate($requiredDate = null)
    {
        // validation for constraint: string
        if (!is_null($requiredDate) && !is_string($requiredDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requiredDate, true), gettype($requiredDate)), __LINE__);
        }
        $this->requiredDate = $requiredDate;
        return $this;
    }
    /**
     * Get salesOrderTotal value
     * @return string|null
     */
    public function getSalesOrderTotal()
    {
        return $this->salesOrderTotal;
    }
    /**
     * Set salesOrderTotal value
     * @param string $salesOrderTotal
     * @return \StructType\SalesOrderData
     */
    public function setSalesOrderTotal($salesOrderTotal = null)
    {
        // validation for constraint: string
        if (!is_null($salesOrderTotal) && !is_string($salesOrderTotal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($salesOrderTotal, true), gettype($salesOrderTotal)), __LINE__);
        }
        $this->salesOrderTotal = $salesOrderTotal;
        return $this;
    }
    /**
     * Get address value
     * @return \StructType\SalesOrderAddress|null
     */
    public function getAddress()
    {
        return $this->address;
    }
    /**
     * Set address value
     * @param \StructType\SalesOrderAddress $address
     * @return \StructType\SalesOrderData
     */
    public function setAddress(\StructType\SalesOrderAddress $address = null)
    {
        $this->address = $address;
        return $this;
    }
    /**
     * Get items value
     * @return \StructType\SalesOrderItem[]|null
     */
    public function getItems()
    {
        return $this->items;
    }
    /**
     * This method is responsible for validating the values passed to the setItems method
     * This method is willingly generated in order to preserve the one-line inline validation within the setItems method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateItemsForArrayConstraintsFromSetItems(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $salesOrderDataItemsItem) {
            // validation for constraint: itemType
            if (!$salesOrderDataItemsItem instanceof \StructType\SalesOrderItem) {
                $invalidValues[] = is_object($salesOrderDataItemsItem) ? get_class($salesOrderDataItemsItem) : sprintf('%s(%s)', gettype($salesOrderDataItemsItem), var_export($salesOrderDataItemsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The items property can only contain items of type \StructType\SalesOrderItem, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set items value
     * @throws \InvalidArgumentException
     * @param \StructType\SalesOrderItem[] $items
     * @return \StructType\SalesOrderData
     */
    public function setItems(array $items = array())
    {
        // validation for constraint: array
        if ('' !== ($itemsArrayErrorMessage = self::validateItemsForArrayConstraintsFromSetItems($items))) {
            throw new \InvalidArgumentException($itemsArrayErrorMessage, __LINE__);
        }
        $this->items = $items;
        return $this;
    }
    /**
     * Add item to items value
     * @throws \InvalidArgumentException
     * @param \StructType\SalesOrderItem $item
     * @return \StructType\SalesOrderData
     */
    public function addToItems(\StructType\SalesOrderItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SalesOrderItem) {
            throw new \InvalidArgumentException(sprintf('The items property can only contain items of type \StructType\SalesOrderItem, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->items[] = $item;
        return $this;
    }
    /**
     * Get customerNumber value
     * @return string|null
     */
    public function getCustomerNumber()
    {
        return $this->customerNumber;
    }
    /**
     * Set customerNumber value
     * @param string $customerNumber
     * @return \StructType\SalesOrderData
     */
    public function setCustomerNumber($customerNumber = null)
    {
        // validation for constraint: string
        if (!is_null($customerNumber) && !is_string($customerNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerNumber, true), gettype($customerNumber)), __LINE__);
        }
        $this->customerNumber = $customerNumber;
        return $this;
    }
    /**
     * Get hitOrderNumber value
     * @return string|null
     */
    public function getHitOrderNumber()
    {
        return $this->hitOrderNumber;
    }
    /**
     * Set hitOrderNumber value
     * @param string $hitOrderNumber
     * @return \StructType\SalesOrderData
     */
    public function setHitOrderNumber($hitOrderNumber = null)
    {
        // validation for constraint: string
        if (!is_null($hitOrderNumber) && !is_string($hitOrderNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hitOrderNumber, true), gettype($hitOrderNumber)), __LINE__);
        }
        $this->hitOrderNumber = $hitOrderNumber;
        return $this;
    }
    /**
     * Get hitOrderSuffix value
     * @return string|null
     */
    public function getHitOrderSuffix()
    {
        return $this->hitOrderSuffix;
    }
    /**
     * Set hitOrderSuffix value
     * @param string $hitOrderSuffix
     * @return \StructType\SalesOrderData
     */
    public function setHitOrderSuffix($hitOrderSuffix = null)
    {
        // validation for constraint: string
        if (!is_null($hitOrderSuffix) && !is_string($hitOrderSuffix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hitOrderSuffix, true), gettype($hitOrderSuffix)), __LINE__);
        }
        $this->hitOrderSuffix = $hitOrderSuffix;
        return $this;
    }
    /**
     * Get purchaseOrderNumber value
     * @return string|null
     */
    public function getPurchaseOrderNumber()
    {
        return $this->purchaseOrderNumber;
    }
    /**
     * Set purchaseOrderNumber value
     * @param string $purchaseOrderNumber
     * @return \StructType\SalesOrderData
     */
    public function setPurchaseOrderNumber($purchaseOrderNumber = null)
    {
        // validation for constraint: string
        if (!is_null($purchaseOrderNumber) && !is_string($purchaseOrderNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($purchaseOrderNumber, true), gettype($purchaseOrderNumber)), __LINE__);
        }
        $this->purchaseOrderNumber = $purchaseOrderNumber;
        return $this;
    }
    /**
     * Get isBackOrder value
     * @return bool|null
     */
    public function getIsBackOrder()
    {
        return $this->isBackOrder;
    }
    /**
     * Set isBackOrder value
     * @param bool $isBackOrder
     * @return \StructType\SalesOrderData
     */
    public function setIsBackOrder($isBackOrder = null)
    {
        // validation for constraint: boolean
        if (!is_null($isBackOrder) && !is_bool($isBackOrder)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isBackOrder, true), gettype($isBackOrder)), __LINE__);
        }
        $this->isBackOrder = $isBackOrder;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SalesOrderData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
