<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HitOrder StructType
 * @subpackage Structs
 */
class HitOrder extends AbstractStructBase
{
    /**
     * The customerNumber
     * @var string
     */
    public $customerNumber;
    /**
     * The hitOrderNumber
     * @var string
     */
    public $hitOrderNumber;
    /**
     * The hitOrderSuffix
     * @var string
     */
    public $hitOrderSuffix;
    /**
     * The purchaseOrderNumber
     * @var string
     */
    public $purchaseOrderNumber;
    /**
     * The isBackOrder
     * @var bool
     */
    public $isBackOrder;
    /**
     * Constructor method for HitOrder
     * @uses HitOrder::setCustomerNumber()
     * @uses HitOrder::setHitOrderNumber()
     * @uses HitOrder::setHitOrderSuffix()
     * @uses HitOrder::setPurchaseOrderNumber()
     * @uses HitOrder::setIsBackOrder()
     * @param string $customerNumber
     * @param string $hitOrderNumber
     * @param string $hitOrderSuffix
     * @param string $purchaseOrderNumber
     * @param bool $isBackOrder
     */
    public function __construct($customerNumber = null, $hitOrderNumber = null, $hitOrderSuffix = null, $purchaseOrderNumber = null, $isBackOrder = null)
    {
        $this
            ->setCustomerNumber($customerNumber)
            ->setHitOrderNumber($hitOrderNumber)
            ->setHitOrderSuffix($hitOrderSuffix)
            ->setPurchaseOrderNumber($purchaseOrderNumber)
            ->setIsBackOrder($isBackOrder);
    }
    /**
     * Get customerNumber value
     * @return string|null
     */
    public function getCustomerNumber()
    {
        return $this->customerNumber;
    }
    /**
     * Set customerNumber value
     * @param string $customerNumber
     * @return \StructType\HitOrder
     */
    public function setCustomerNumber($customerNumber = null)
    {
        // validation for constraint: string
        if (!is_null($customerNumber) && !is_string($customerNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerNumber, true), gettype($customerNumber)), __LINE__);
        }
        $this->customerNumber = $customerNumber;
        return $this;
    }
    /**
     * Get hitOrderNumber value
     * @return string|null
     */
    public function getHitOrderNumber()
    {
        return $this->hitOrderNumber;
    }
    /**
     * Set hitOrderNumber value
     * @param string $hitOrderNumber
     * @return \StructType\HitOrder
     */
    public function setHitOrderNumber($hitOrderNumber = null)
    {
        // validation for constraint: string
        if (!is_null($hitOrderNumber) && !is_string($hitOrderNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hitOrderNumber, true), gettype($hitOrderNumber)), __LINE__);
        }
        $this->hitOrderNumber = $hitOrderNumber;
        return $this;
    }
    /**
     * Get hitOrderSuffix value
     * @return string|null
     */
    public function getHitOrderSuffix()
    {
        return $this->hitOrderSuffix;
    }
    /**
     * Set hitOrderSuffix value
     * @param string $hitOrderSuffix
     * @return \StructType\HitOrder
     */
    public function setHitOrderSuffix($hitOrderSuffix = null)
    {
        // validation for constraint: string
        if (!is_null($hitOrderSuffix) && !is_string($hitOrderSuffix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hitOrderSuffix, true), gettype($hitOrderSuffix)), __LINE__);
        }
        $this->hitOrderSuffix = $hitOrderSuffix;
        return $this;
    }
    /**
     * Get purchaseOrderNumber value
     * @return string|null
     */
    public function getPurchaseOrderNumber()
    {
        return $this->purchaseOrderNumber;
    }
    /**
     * Set purchaseOrderNumber value
     * @param string $purchaseOrderNumber
     * @return \StructType\HitOrder
     */
    public function setPurchaseOrderNumber($purchaseOrderNumber = null)
    {
        // validation for constraint: string
        if (!is_null($purchaseOrderNumber) && !is_string($purchaseOrderNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($purchaseOrderNumber, true), gettype($purchaseOrderNumber)), __LINE__);
        }
        $this->purchaseOrderNumber = $purchaseOrderNumber;
        return $this;
    }
    /**
     * Get isBackOrder value
     * @return bool|null
     */
    public function getIsBackOrder()
    {
        return $this->isBackOrder;
    }
    /**
     * Set isBackOrder value
     * @param bool $isBackOrder
     * @return \StructType\HitOrder
     */
    public function setIsBackOrder($isBackOrder = null)
    {
        // validation for constraint: boolean
        if (!is_null($isBackOrder) && !is_bool($isBackOrder)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isBackOrder, true), gettype($isBackOrder)), __LINE__);
        }
        $this->isBackOrder = $isBackOrder;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\HitOrder
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
