<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HitOrderDetail StructType
 * @subpackage Structs
 */
class HitOrderDetail extends AbstractStructBase
{
    /**
     * The lineNumber
     * @var string
     */
    public $lineNumber;
    /**
     * The productNumber
     * @var string
     */
    public $productNumber;
    /**
     * The orderQuantity
     * @var string
     */
    public $orderQuantity;
    /**
     * The productColor
     * @var string
     */
    public $productColor;
    /**
     * The productSize
     * @var string
     */
    public $productSize;
    /**
     * The itemNumber
     * @var string
     */
    public $itemNumber;
    /**
     * The unitPrice
     * @var string
     */
    public $unitPrice;
    /**
     * The shipDate
     * @var string
     */
    public $shipDate;
    /**
     * Constructor method for HitOrderDetail
     * @uses HitOrderDetail::setLineNumber()
     * @uses HitOrderDetail::setProductNumber()
     * @uses HitOrderDetail::setOrderQuantity()
     * @uses HitOrderDetail::setProductColor()
     * @uses HitOrderDetail::setProductSize()
     * @uses HitOrderDetail::setItemNumber()
     * @uses HitOrderDetail::setUnitPrice()
     * @uses HitOrderDetail::setShipDate()
     * @param string $lineNumber
     * @param string $productNumber
     * @param string $orderQuantity
     * @param string $productColor
     * @param string $productSize
     * @param string $itemNumber
     * @param string $unitPrice
     * @param string $shipDate
     */
    public function __construct($lineNumber = null, $productNumber = null, $orderQuantity = null, $productColor = null, $productSize = null, $itemNumber = null, $unitPrice = null, $shipDate = null)
    {
        $this
            ->setLineNumber($lineNumber)
            ->setProductNumber($productNumber)
            ->setOrderQuantity($orderQuantity)
            ->setProductColor($productColor)
            ->setProductSize($productSize)
            ->setItemNumber($itemNumber)
            ->setUnitPrice($unitPrice)
            ->setShipDate($shipDate);
    }
    /**
     * Get lineNumber value
     * @return string|null
     */
    public function getLineNumber()
    {
        return $this->lineNumber;
    }
    /**
     * Set lineNumber value
     * @param string $lineNumber
     * @return \StructType\HitOrderDetail
     */
    public function setLineNumber($lineNumber = null)
    {
        // validation for constraint: string
        if (!is_null($lineNumber) && !is_string($lineNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lineNumber, true), gettype($lineNumber)), __LINE__);
        }
        $this->lineNumber = $lineNumber;
        return $this;
    }
    /**
     * Get productNumber value
     * @return string|null
     */
    public function getProductNumber()
    {
        return $this->productNumber;
    }
    /**
     * Set productNumber value
     * @param string $productNumber
     * @return \StructType\HitOrderDetail
     */
    public function setProductNumber($productNumber = null)
    {
        // validation for constraint: string
        if (!is_null($productNumber) && !is_string($productNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productNumber, true), gettype($productNumber)), __LINE__);
        }
        $this->productNumber = $productNumber;
        return $this;
    }
    /**
     * Get orderQuantity value
     * @return string|null
     */
    public function getOrderQuantity()
    {
        return $this->orderQuantity;
    }
    /**
     * Set orderQuantity value
     * @param string $orderQuantity
     * @return \StructType\HitOrderDetail
     */
    public function setOrderQuantity($orderQuantity = null)
    {
        // validation for constraint: string
        if (!is_null($orderQuantity) && !is_string($orderQuantity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderQuantity, true), gettype($orderQuantity)), __LINE__);
        }
        $this->orderQuantity = $orderQuantity;
        return $this;
    }
    /**
     * Get productColor value
     * @return string|null
     */
    public function getProductColor()
    {
        return $this->productColor;
    }
    /**
     * Set productColor value
     * @param string $productColor
     * @return \StructType\HitOrderDetail
     */
    public function setProductColor($productColor = null)
    {
        // validation for constraint: string
        if (!is_null($productColor) && !is_string($productColor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productColor, true), gettype($productColor)), __LINE__);
        }
        $this->productColor = $productColor;
        return $this;
    }
    /**
     * Get productSize value
     * @return string|null
     */
    public function getProductSize()
    {
        return $this->productSize;
    }
    /**
     * Set productSize value
     * @param string $productSize
     * @return \StructType\HitOrderDetail
     */
    public function setProductSize($productSize = null)
    {
        // validation for constraint: string
        if (!is_null($productSize) && !is_string($productSize)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productSize, true), gettype($productSize)), __LINE__);
        }
        $this->productSize = $productSize;
        return $this;
    }
    /**
     * Get itemNumber value
     * @return string|null
     */
    public function getItemNumber()
    {
        return $this->itemNumber;
    }
    /**
     * Set itemNumber value
     * @param string $itemNumber
     * @return \StructType\HitOrderDetail
     */
    public function setItemNumber($itemNumber = null)
    {
        // validation for constraint: string
        if (!is_null($itemNumber) && !is_string($itemNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemNumber, true), gettype($itemNumber)), __LINE__);
        }
        $this->itemNumber = $itemNumber;
        return $this;
    }
    /**
     * Get unitPrice value
     * @return string|null
     */
    public function getUnitPrice()
    {
        return $this->unitPrice;
    }
    /**
     * Set unitPrice value
     * @param string $unitPrice
     * @return \StructType\HitOrderDetail
     */
    public function setUnitPrice($unitPrice = null)
    {
        // validation for constraint: string
        if (!is_null($unitPrice) && !is_string($unitPrice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($unitPrice, true), gettype($unitPrice)), __LINE__);
        }
        $this->unitPrice = $unitPrice;
        return $this;
    }
    /**
     * Get shipDate value
     * @return string|null
     */
    public function getShipDate()
    {
        return $this->shipDate;
    }
    /**
     * Set shipDate value
     * @param string $shipDate
     * @return \StructType\HitOrderDetail
     */
    public function setShipDate($shipDate = null)
    {
        // validation for constraint: string
        if (!is_null($shipDate) && !is_string($shipDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipDate, true), gettype($shipDate)), __LINE__);
        }
        $this->shipDate = $shipDate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\HitOrderDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
