<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductPrice StructType
 * @subpackage Structs
 */
class ProductPrice extends AbstractStructBase
{
    /**
     * The product
     * @var string
     */
    public $product;
    /**
     * The price
     * @var string
     */
    public $price;
    /**
     * The quantity
     * @var string
     */
    public $quantity;
    /**
     * The customerDiscount
     * @var string
     */
    public $customerDiscount;
    /**
     * The priceCategory
     * @var string
     */
    public $priceCategory;
    /**
     * Constructor method for ProductPrice
     * @uses ProductPrice::setProduct()
     * @uses ProductPrice::setPrice()
     * @uses ProductPrice::setQuantity()
     * @uses ProductPrice::setCustomerDiscount()
     * @uses ProductPrice::setPriceCategory()
     * @param string $product
     * @param string $price
     * @param string $quantity
     * @param string $customerDiscount
     * @param string $priceCategory
     */
    public function __construct($product = null, $price = null, $quantity = null, $customerDiscount = null, $priceCategory = null)
    {
        $this
            ->setProduct($product)
            ->setPrice($price)
            ->setQuantity($quantity)
            ->setCustomerDiscount($customerDiscount)
            ->setPriceCategory($priceCategory);
    }
    /**
     * Get product value
     * @return string|null
     */
    public function getProduct()
    {
        return $this->product;
    }
    /**
     * Set product value
     * @param string $product
     * @return \StructType\ProductPrice
     */
    public function setProduct($product = null)
    {
        // validation for constraint: string
        if (!is_null($product) && !is_string($product)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($product, true), gettype($product)), __LINE__);
        }
        $this->product = $product;
        return $this;
    }
    /**
     * Get price value
     * @return string|null
     */
    public function getPrice()
    {
        return $this->price;
    }
    /**
     * Set price value
     * @param string $price
     * @return \StructType\ProductPrice
     */
    public function setPrice($price = null)
    {
        // validation for constraint: string
        if (!is_null($price) && !is_string($price)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($price, true), gettype($price)), __LINE__);
        }
        $this->price = $price;
        return $this;
    }
    /**
     * Get quantity value
     * @return string|null
     */
    public function getQuantity()
    {
        return $this->quantity;
    }
    /**
     * Set quantity value
     * @param string $quantity
     * @return \StructType\ProductPrice
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: string
        if (!is_null($quantity) && !is_string($quantity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->quantity = $quantity;
        return $this;
    }
    /**
     * Get customerDiscount value
     * @return string|null
     */
    public function getCustomerDiscount()
    {
        return $this->customerDiscount;
    }
    /**
     * Set customerDiscount value
     * @param string $customerDiscount
     * @return \StructType\ProductPrice
     */
    public function setCustomerDiscount($customerDiscount = null)
    {
        // validation for constraint: string
        if (!is_null($customerDiscount) && !is_string($customerDiscount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerDiscount, true), gettype($customerDiscount)), __LINE__);
        }
        $this->customerDiscount = $customerDiscount;
        return $this;
    }
    /**
     * Get priceCategory value
     * @return string|null
     */
    public function getPriceCategory()
    {
        return $this->priceCategory;
    }
    /**
     * Set priceCategory value
     * @param string $priceCategory
     * @return \StructType\ProductPrice
     */
    public function setPriceCategory($priceCategory = null)
    {
        // validation for constraint: string
        if (!is_null($priceCategory) && !is_string($priceCategory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceCategory, true), gettype($priceCategory)), __LINE__);
        }
        $this->priceCategory = $priceCategory;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ProductPrice
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
