<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PricingResponse StructType
 * @subpackage Structs
 */
class PricingResponse extends AbstractStructBase
{
    /**
     * The productPrices
     * Meta information extracted from the WSDL
     * - arrayType: tns:ProductPrice[]
     * - base: soap-enc:Array
     * - ref: soap-enc:arrayType
     * @var \StructType\ProductPrice[]
     */
    public $productPrices;
    /**
     * The additionalCharges
     * Meta information extracted from the WSDL
     * - arrayType: tns:AdditionalCharge[]
     * - base: soap-enc:Array
     * - ref: soap-enc:arrayType
     * @var \StructType\AdditionalCharge[]
     */
    public $additionalCharges;
    /**
     * Constructor method for PricingResponse
     * @uses PricingResponse::setProductPrices()
     * @uses PricingResponse::setAdditionalCharges()
     * @param \StructType\ProductPrice[] $productPrices
     * @param \StructType\AdditionalCharge[] $additionalCharges
     */
    public function __construct(array $productPrices = array(), array $additionalCharges = array())
    {
        $this
            ->setProductPrices($productPrices)
            ->setAdditionalCharges($additionalCharges);
    }
    /**
     * Get productPrices value
     * @return \StructType\ProductPrice[]|null
     */
    public function getProductPrices()
    {
        return $this->productPrices;
    }
    /**
     * This method is responsible for validating the values passed to the setProductPrices method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProductPrices method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProductPricesForArrayConstraintsFromSetProductPrices(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $pricingResponseProductPricesItem) {
            // validation for constraint: itemType
            if (!$pricingResponseProductPricesItem instanceof \StructType\ProductPrice) {
                $invalidValues[] = is_object($pricingResponseProductPricesItem) ? get_class($pricingResponseProductPricesItem) : sprintf('%s(%s)', gettype($pricingResponseProductPricesItem), var_export($pricingResponseProductPricesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The productPrices property can only contain items of type \StructType\ProductPrice, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set productPrices value
     * @throws \InvalidArgumentException
     * @param \StructType\ProductPrice[] $productPrices
     * @return \StructType\PricingResponse
     */
    public function setProductPrices(array $productPrices = array())
    {
        // validation for constraint: array
        if ('' !== ($productPricesArrayErrorMessage = self::validateProductPricesForArrayConstraintsFromSetProductPrices($productPrices))) {
            throw new \InvalidArgumentException($productPricesArrayErrorMessage, __LINE__);
        }
        $this->productPrices = $productPrices;
        return $this;
    }
    /**
     * Add item to productPrices value
     * @throws \InvalidArgumentException
     * @param \StructType\ProductPrice $item
     * @return \StructType\PricingResponse
     */
    public function addToProductPrices(\StructType\ProductPrice $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ProductPrice) {
            throw new \InvalidArgumentException(sprintf('The productPrices property can only contain items of type \StructType\ProductPrice, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->productPrices[] = $item;
        return $this;
    }
    /**
     * Get additionalCharges value
     * @return \StructType\AdditionalCharge[]|null
     */
    public function getAdditionalCharges()
    {
        return $this->additionalCharges;
    }
    /**
     * This method is responsible for validating the values passed to the setAdditionalCharges method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAdditionalCharges method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAdditionalChargesForArrayConstraintsFromSetAdditionalCharges(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $pricingResponseAdditionalChargesItem) {
            // validation for constraint: itemType
            if (!$pricingResponseAdditionalChargesItem instanceof \StructType\AdditionalCharge) {
                $invalidValues[] = is_object($pricingResponseAdditionalChargesItem) ? get_class($pricingResponseAdditionalChargesItem) : sprintf('%s(%s)', gettype($pricingResponseAdditionalChargesItem), var_export($pricingResponseAdditionalChargesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The additionalCharges property can only contain items of type \StructType\AdditionalCharge, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set additionalCharges value
     * @throws \InvalidArgumentException
     * @param \StructType\AdditionalCharge[] $additionalCharges
     * @return \StructType\PricingResponse
     */
    public function setAdditionalCharges(array $additionalCharges = array())
    {
        // validation for constraint: array
        if ('' !== ($additionalChargesArrayErrorMessage = self::validateAdditionalChargesForArrayConstraintsFromSetAdditionalCharges($additionalCharges))) {
            throw new \InvalidArgumentException($additionalChargesArrayErrorMessage, __LINE__);
        }
        $this->additionalCharges = $additionalCharges;
        return $this;
    }
    /**
     * Add item to additionalCharges value
     * @throws \InvalidArgumentException
     * @param \StructType\AdditionalCharge $item
     * @return \StructType\PricingResponse
     */
    public function addToAdditionalCharges(\StructType\AdditionalCharge $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AdditionalCharge) {
            throw new \InvalidArgumentException(sprintf('The additionalCharges property can only contain items of type \StructType\AdditionalCharge, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->additionalCharges[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PricingResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
