<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AdditionalCharge StructType
 * @subpackage Structs
 */
class AdditionalCharge extends AbstractStructBase
{
    /**
     * The chargeName
     * @var string
     */
    public $chargeName;
    /**
     * The chargeDescription
     * @var string
     */
    public $chargeDescription;
    /**
     * The additionalChargeAmount
     * @var string
     */
    public $additionalChargeAmount;
    /**
     * Constructor method for AdditionalCharge
     * @uses AdditionalCharge::setChargeName()
     * @uses AdditionalCharge::setChargeDescription()
     * @uses AdditionalCharge::setAdditionalChargeAmount()
     * @param string $chargeName
     * @param string $chargeDescription
     * @param string $additionalChargeAmount
     */
    public function __construct($chargeName = null, $chargeDescription = null, $additionalChargeAmount = null)
    {
        $this
            ->setChargeName($chargeName)
            ->setChargeDescription($chargeDescription)
            ->setAdditionalChargeAmount($additionalChargeAmount);
    }
    /**
     * Get chargeName value
     * @return string|null
     */
    public function getChargeName()
    {
        return $this->chargeName;
    }
    /**
     * Set chargeName value
     * @param string $chargeName
     * @return \StructType\AdditionalCharge
     */
    public function setChargeName($chargeName = null)
    {
        // validation for constraint: string
        if (!is_null($chargeName) && !is_string($chargeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($chargeName, true), gettype($chargeName)), __LINE__);
        }
        $this->chargeName = $chargeName;
        return $this;
    }
    /**
     * Get chargeDescription value
     * @return string|null
     */
    public function getChargeDescription()
    {
        return $this->chargeDescription;
    }
    /**
     * Set chargeDescription value
     * @param string $chargeDescription
     * @return \StructType\AdditionalCharge
     */
    public function setChargeDescription($chargeDescription = null)
    {
        // validation for constraint: string
        if (!is_null($chargeDescription) && !is_string($chargeDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($chargeDescription, true), gettype($chargeDescription)), __LINE__);
        }
        $this->chargeDescription = $chargeDescription;
        return $this;
    }
    /**
     * Get additionalChargeAmount value
     * @return string|null
     */
    public function getAdditionalChargeAmount()
    {
        return $this->additionalChargeAmount;
    }
    /**
     * Set additionalChargeAmount value
     * @param string $additionalChargeAmount
     * @return \StructType\AdditionalCharge
     */
    public function setAdditionalChargeAmount($additionalChargeAmount = null)
    {
        // validation for constraint: string
        if (!is_null($additionalChargeAmount) && !is_string($additionalChargeAmount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($additionalChargeAmount, true), gettype($additionalChargeAmount)), __LINE__);
        }
        $this->additionalChargeAmount = $additionalChargeAmount;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AdditionalCharge
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
