<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://ds.hitpromo.net/orderShipment',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://ds.hitpromo.net/orderShipment',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Create ServiceType
 */
$create = new \ServiceType\Create($options);
/**
 * Sample call for createOrderHeader operation/method
 */
if ($create->createOrderHeader($userCredential, $customerNumber, $purchaseOrderNumber, $user, $dups, $comments) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Samples for Update ServiceType
 */
$update = new \ServiceType\Update($options);
/**
 * Sample call for updateShippingDestination operation/method
 */
if ($update->updateShippingDestination($userCredential, $customerNumber, $salesOrderNumber, $suffix, $contactName, $address1, $address2, $address3, $city, $state, $zip, $user) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Samples for Add ServiceType
 */
$add = new \ServiceType\Add($options);
/**
 * Sample call for addUpdateShippingDestination operation/method
 */
if ($add->addUpdateShippingDestination($userCredential, $customerNumber, $salesOrderNumber, $contactName, $address1, $address2, $address3, $city, $state, $zip, $quantity, $country, $user, $sequence, $carrier, $instructions, $whatToDo) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Samples for Change ServiceType
 */
$change = new \ServiceType\Change($options);
/**
 * Sample call for changeShipMethod operation/method
 */
if ($change->changeShipMethod($userCredential, $customerNumber, $salesOrderNumber, $suffix, $carrier, $user) !== false) {
    print_r($change->getResult());
} else {
    print_r($change->getLastError());
}
