<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Create ServiceType
 * @subpackage Services
 */
class Create extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named createOrderHeader
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $userCredential
     * @param string $customerNumber
     * @param string $purchaseOrderNumber
     * @param string $user
     * @param string $dups
     * @param string $comments
     * @return string|bool
     */
    public function createOrderHeader($userCredential, $customerNumber, $purchaseOrderNumber, $user, $dups, $comments)
    {
        try {
            $this->setResult($this->getSoapClient()->createOrderHeader($userCredential, $customerNumber, $purchaseOrderNumber, $user, $dups, $comments));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return string
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
