<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Change ServiceType
 * @subpackage Services
 */
class Change extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named changeShipMethod
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $userCredential
     * @param string $customerNumber
     * @param string $salesOrderNumber
     * @param string $suffix
     * @param string $carrier
     * @param string $user
     * @return int|bool
     */
    public function changeShipMethod($userCredential, $customerNumber, $salesOrderNumber, $suffix, $carrier, $user)
    {
        try {
            $this->setResult($this->getSoapClient()->changeShipMethod($userCredential, $customerNumber, $salesOrderNumber, $suffix, $carrier, $user));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return int
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
