<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Update ServiceType
 * @subpackage Services
 */
class Update extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named updateShippingDestination
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $userCredential
     * @param string $customerNumber
     * @param string $salesOrderNumber
     * @param string $suffix
     * @param string $contactName
     * @param string $address1
     * @param string $address2
     * @param string $address3
     * @param string $city
     * @param string $state
     * @param string $zip
     * @param string $user
     * @return int|bool
     */
    public function updateShippingDestination($userCredential, $customerNumber, $salesOrderNumber, $suffix, $contactName, $address1, $address2, $address3, $city, $state, $zip, $user)
    {
        try {
            $this->setResult($this->getSoapClient()->updateShippingDestination($userCredential, $customerNumber, $salesOrderNumber, $suffix, $contactName, $address1, $address2, $address3, $city, $state, $zip, $user));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return int
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
