<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Add ServiceType
 * @subpackage Services
 */
class Add extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named addUpdateShippingDestination
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $userCredential
     * @param string $customerNumber
     * @param string $salesOrderNumber
     * @param string $contactName
     * @param string $address1
     * @param string $address2
     * @param string $address3
     * @param string $city
     * @param string $state
     * @param string $zip
     * @param string $quantity
     * @param string $country
     * @param string $user
     * @param string $sequence
     * @param string $carrier
     * @param string $instructions
     * @param string $whatToDo
     * @return int|bool
     */
    public function addUpdateShippingDestination($userCredential, $customerNumber, $salesOrderNumber, $contactName, $address1, $address2, $address3, $city, $state, $zip, $quantity, $country, $user, $sequence, $carrier, $instructions, $whatToDo)
    {
        try {
            $this->setResult($this->getSoapClient()->addUpdateShippingDestination($userCredential, $customerNumber, $salesOrderNumber, $contactName, $address1, $address2, $address3, $city, $state, $zip, $quantity, $country, $user, $sequence, $carrier, $instructions, $whatToDo));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return int
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
