<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductInfo StructType
 * @subpackage Structs
 */
class ProductInfo extends AbstractStructBase
{
    /**
     * The number
     * @var string
     */
    public $number;
    /**
     * The productUrl
     * @var string
     */
    public $productUrl;
    /**
     * The name
     * @var string
     */
    public $name;
    /**
     * The categories
     * Meta information extracted from the WSDL
     * - arrayType: xsd:string[]
     * - base: soap-enc:Array
     * - ref: soap-enc:arrayType
     * @var string[]
     */
    public $categories;
    /**
     * The descriptions
     * Meta information extracted from the WSDL
     * - arrayType: xsd:string[]
     * - base: soap-enc:Array
     * - ref: soap-enc:arrayType
     * @var string[]
     */
    public $descriptions;
    /**
     * The properties
     * Meta information extracted from the WSDL
     * - arrayType: xsd:string[]
     * - base: soap-enc:Array
     * - ref: soap-enc:arrayType
     * @var string[]
     */
    public $properties;
    /**
     * The pricingGrid
     * Meta information extracted from the WSDL
     * - arrayType: tns:PricingGrid[]
     * - base: soap-enc:Array
     * - ref: soap-enc:arrayType
     * @var \StructType\PricingGrid[]
     */
    public $pricingGrid;
    /**
     * The images
     * @var \StructType\ProductImageResult
     */
    public $images;
    /**
     * The colors
     * Meta information extracted from the WSDL
     * - arrayType: xsd:string[]
     * - base: soap-enc:Array
     * - ref: soap-enc:arrayType
     * @var string[]
     */
    public $colors;
    /**
     * The weightLbs
     * @var string
     */
    public $weightLbs;
    /**
     * The weightPer
     * @var string
     */
    public $weightPer;
    /**
     * Constructor method for ProductInfo
     * @uses ProductInfo::setNumber()
     * @uses ProductInfo::setProductUrl()
     * @uses ProductInfo::setName()
     * @uses ProductInfo::setCategories()
     * @uses ProductInfo::setDescriptions()
     * @uses ProductInfo::setProperties()
     * @uses ProductInfo::setPricingGrid()
     * @uses ProductInfo::setImages()
     * @uses ProductInfo::setColors()
     * @uses ProductInfo::setWeightLbs()
     * @uses ProductInfo::setWeightPer()
     * @param string $number
     * @param string $productUrl
     * @param string $name
     * @param string[] $categories
     * @param string[] $descriptions
     * @param string[] $properties
     * @param \StructType\PricingGrid[] $pricingGrid
     * @param \StructType\ProductImageResult $images
     * @param string[] $colors
     * @param string $weightLbs
     * @param string $weightPer
     */
    public function __construct($number = null, $productUrl = null, $name = null, array $categories = array(), array $descriptions = array(), array $properties = array(), array $pricingGrid = array(), \StructType\ProductImageResult $images = null, array $colors = array(), $weightLbs = null, $weightPer = null)
    {
        $this
            ->setNumber($number)
            ->setProductUrl($productUrl)
            ->setName($name)
            ->setCategories($categories)
            ->setDescriptions($descriptions)
            ->setProperties($properties)
            ->setPricingGrid($pricingGrid)
            ->setImages($images)
            ->setColors($colors)
            ->setWeightLbs($weightLbs)
            ->setWeightPer($weightPer);
    }
    /**
     * Get number value
     * @return string|null
     */
    public function getNumber()
    {
        return $this->number;
    }
    /**
     * Set number value
     * @param string $number
     * @return \StructType\ProductInfo
     */
    public function setNumber($number = null)
    {
        // validation for constraint: string
        if (!is_null($number) && !is_string($number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($number, true), gettype($number)), __LINE__);
        }
        $this->number = $number;
        return $this;
    }
    /**
     * Get productUrl value
     * @return string|null
     */
    public function getProductUrl()
    {
        return $this->productUrl;
    }
    /**
     * Set productUrl value
     * @param string $productUrl
     * @return \StructType\ProductInfo
     */
    public function setProductUrl($productUrl = null)
    {
        // validation for constraint: string
        if (!is_null($productUrl) && !is_string($productUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productUrl, true), gettype($productUrl)), __LINE__);
        }
        $this->productUrl = $productUrl;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\ProductInfo
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get categories value
     * @return string[]|null
     */
    public function getCategories()
    {
        return $this->categories;
    }
    /**
     * This method is responsible for validating the values passed to the setCategories method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCategories method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCategoriesForArrayConstraintsFromSetCategories(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $productInfoCategoriesItem) {
            // validation for constraint: itemType
            if (!is_string($productInfoCategoriesItem)) {
                $invalidValues[] = is_object($productInfoCategoriesItem) ? get_class($productInfoCategoriesItem) : sprintf('%s(%s)', gettype($productInfoCategoriesItem), var_export($productInfoCategoriesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The categories property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set categories value
     * @throws \InvalidArgumentException
     * @param string[] $categories
     * @return \StructType\ProductInfo
     */
    public function setCategories(array $categories = array())
    {
        // validation for constraint: array
        if ('' !== ($categoriesArrayErrorMessage = self::validateCategoriesForArrayConstraintsFromSetCategories($categories))) {
            throw new \InvalidArgumentException($categoriesArrayErrorMessage, __LINE__);
        }
        $this->categories = $categories;
        return $this;
    }
    /**
     * Add item to categories value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\ProductInfo
     */
    public function addToCategories($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The categories property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->categories[] = $item;
        return $this;
    }
    /**
     * Get descriptions value
     * @return string[]|null
     */
    public function getDescriptions()
    {
        return $this->descriptions;
    }
    /**
     * This method is responsible for validating the values passed to the setDescriptions method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDescriptions method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDescriptionsForArrayConstraintsFromSetDescriptions(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $productInfoDescriptionsItem) {
            // validation for constraint: itemType
            if (!is_string($productInfoDescriptionsItem)) {
                $invalidValues[] = is_object($productInfoDescriptionsItem) ? get_class($productInfoDescriptionsItem) : sprintf('%s(%s)', gettype($productInfoDescriptionsItem), var_export($productInfoDescriptionsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The descriptions property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set descriptions value
     * @throws \InvalidArgumentException
     * @param string[] $descriptions
     * @return \StructType\ProductInfo
     */
    public function setDescriptions(array $descriptions = array())
    {
        // validation for constraint: array
        if ('' !== ($descriptionsArrayErrorMessage = self::validateDescriptionsForArrayConstraintsFromSetDescriptions($descriptions))) {
            throw new \InvalidArgumentException($descriptionsArrayErrorMessage, __LINE__);
        }
        $this->descriptions = $descriptions;
        return $this;
    }
    /**
     * Add item to descriptions value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\ProductInfo
     */
    public function addToDescriptions($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The descriptions property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->descriptions[] = $item;
        return $this;
    }
    /**
     * Get properties value
     * @return string[]|null
     */
    public function getProperties()
    {
        return $this->properties;
    }
    /**
     * This method is responsible for validating the values passed to the setProperties method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProperties method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePropertiesForArrayConstraintsFromSetProperties(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $productInfoPropertiesItem) {
            // validation for constraint: itemType
            if (!is_string($productInfoPropertiesItem)) {
                $invalidValues[] = is_object($productInfoPropertiesItem) ? get_class($productInfoPropertiesItem) : sprintf('%s(%s)', gettype($productInfoPropertiesItem), var_export($productInfoPropertiesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The properties property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set properties value
     * @throws \InvalidArgumentException
     * @param string[] $properties
     * @return \StructType\ProductInfo
     */
    public function setProperties(array $properties = array())
    {
        // validation for constraint: array
        if ('' !== ($propertiesArrayErrorMessage = self::validatePropertiesForArrayConstraintsFromSetProperties($properties))) {
            throw new \InvalidArgumentException($propertiesArrayErrorMessage, __LINE__);
        }
        $this->properties = $properties;
        return $this;
    }
    /**
     * Add item to properties value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\ProductInfo
     */
    public function addToProperties($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The properties property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->properties[] = $item;
        return $this;
    }
    /**
     * Get pricingGrid value
     * @return \StructType\PricingGrid[]|null
     */
    public function getPricingGrid()
    {
        return $this->pricingGrid;
    }
    /**
     * This method is responsible for validating the values passed to the setPricingGrid method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPricingGrid method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePricingGridForArrayConstraintsFromSetPricingGrid(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $productInfoPricingGridItem) {
            // validation for constraint: itemType
            if (!$productInfoPricingGridItem instanceof \StructType\PricingGrid) {
                $invalidValues[] = is_object($productInfoPricingGridItem) ? get_class($productInfoPricingGridItem) : sprintf('%s(%s)', gettype($productInfoPricingGridItem), var_export($productInfoPricingGridItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The pricingGrid property can only contain items of type \StructType\PricingGrid, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set pricingGrid value
     * @throws \InvalidArgumentException
     * @param \StructType\PricingGrid[] $pricingGrid
     * @return \StructType\ProductInfo
     */
    public function setPricingGrid(array $pricingGrid = array())
    {
        // validation for constraint: array
        if ('' !== ($pricingGridArrayErrorMessage = self::validatePricingGridForArrayConstraintsFromSetPricingGrid($pricingGrid))) {
            throw new \InvalidArgumentException($pricingGridArrayErrorMessage, __LINE__);
        }
        $this->pricingGrid = $pricingGrid;
        return $this;
    }
    /**
     * Add item to pricingGrid value
     * @throws \InvalidArgumentException
     * @param \StructType\PricingGrid $item
     * @return \StructType\ProductInfo
     */
    public function addToPricingGrid(\StructType\PricingGrid $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PricingGrid) {
            throw new \InvalidArgumentException(sprintf('The pricingGrid property can only contain items of type \StructType\PricingGrid, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->pricingGrid[] = $item;
        return $this;
    }
    /**
     * Get images value
     * @return \StructType\ProductImageResult|null
     */
    public function getImages()
    {
        return $this->images;
    }
    /**
     * Set images value
     * @param \StructType\ProductImageResult $images
     * @return \StructType\ProductInfo
     */
    public function setImages(\StructType\ProductImageResult $images = null)
    {
        $this->images = $images;
        return $this;
    }
    /**
     * Get colors value
     * @return string[]|null
     */
    public function getColors()
    {
        return $this->colors;
    }
    /**
     * This method is responsible for validating the values passed to the setColors method
     * This method is willingly generated in order to preserve the one-line inline validation within the setColors method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateColorsForArrayConstraintsFromSetColors(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $productInfoColorsItem) {
            // validation for constraint: itemType
            if (!is_string($productInfoColorsItem)) {
                $invalidValues[] = is_object($productInfoColorsItem) ? get_class($productInfoColorsItem) : sprintf('%s(%s)', gettype($productInfoColorsItem), var_export($productInfoColorsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The colors property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set colors value
     * @throws \InvalidArgumentException
     * @param string[] $colors
     * @return \StructType\ProductInfo
     */
    public function setColors(array $colors = array())
    {
        // validation for constraint: array
        if ('' !== ($colorsArrayErrorMessage = self::validateColorsForArrayConstraintsFromSetColors($colors))) {
            throw new \InvalidArgumentException($colorsArrayErrorMessage, __LINE__);
        }
        $this->colors = $colors;
        return $this;
    }
    /**
     * Add item to colors value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\ProductInfo
     */
    public function addToColors($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The colors property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->colors[] = $item;
        return $this;
    }
    /**
     * Get weightLbs value
     * @return string|null
     */
    public function getWeightLbs()
    {
        return $this->weightLbs;
    }
    /**
     * Set weightLbs value
     * @param string $weightLbs
     * @return \StructType\ProductInfo
     */
    public function setWeightLbs($weightLbs = null)
    {
        // validation for constraint: string
        if (!is_null($weightLbs) && !is_string($weightLbs)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($weightLbs, true), gettype($weightLbs)), __LINE__);
        }
        $this->weightLbs = $weightLbs;
        return $this;
    }
    /**
     * Get weightPer value
     * @return string|null
     */
    public function getWeightPer()
    {
        return $this->weightPer;
    }
    /**
     * Set weightPer value
     * @param string $weightPer
     * @return \StructType\ProductInfo
     */
    public function setWeightPer($weightPer = null)
    {
        // validation for constraint: string
        if (!is_null($weightPer) && !is_string($weightPer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($weightPer, true), gettype($weightPer)), __LINE__);
        }
        $this->weightPer = $weightPer;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ProductInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
