<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PricingGrid StructType
 * @subpackage Structs
 */
class PricingGrid extends AbstractStructBase
{
    /**
     * The price
     * @var string
     */
    public $price;
    /**
     * The quantity
     * @var string
     */
    public $quantity;
    /**
     * The discount
     * @var string
     */
    public $discount;
    /**
     * The gridName
     * @var string
     */
    public $gridName;
    /**
     * Constructor method for PricingGrid
     * @uses PricingGrid::setPrice()
     * @uses PricingGrid::setQuantity()
     * @uses PricingGrid::setDiscount()
     * @uses PricingGrid::setGridName()
     * @param string $price
     * @param string $quantity
     * @param string $discount
     * @param string $gridName
     */
    public function __construct($price = null, $quantity = null, $discount = null, $gridName = null)
    {
        $this
            ->setPrice($price)
            ->setQuantity($quantity)
            ->setDiscount($discount)
            ->setGridName($gridName);
    }
    /**
     * Get price value
     * @return string|null
     */
    public function getPrice()
    {
        return $this->price;
    }
    /**
     * Set price value
     * @param string $price
     * @return \StructType\PricingGrid
     */
    public function setPrice($price = null)
    {
        // validation for constraint: string
        if (!is_null($price) && !is_string($price)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($price, true), gettype($price)), __LINE__);
        }
        $this->price = $price;
        return $this;
    }
    /**
     * Get quantity value
     * @return string|null
     */
    public function getQuantity()
    {
        return $this->quantity;
    }
    /**
     * Set quantity value
     * @param string $quantity
     * @return \StructType\PricingGrid
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: string
        if (!is_null($quantity) && !is_string($quantity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->quantity = $quantity;
        return $this;
    }
    /**
     * Get discount value
     * @return string|null
     */
    public function getDiscount()
    {
        return $this->discount;
    }
    /**
     * Set discount value
     * @param string $discount
     * @return \StructType\PricingGrid
     */
    public function setDiscount($discount = null)
    {
        // validation for constraint: string
        if (!is_null($discount) && !is_string($discount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($discount, true), gettype($discount)), __LINE__);
        }
        $this->discount = $discount;
        return $this;
    }
    /**
     * Get gridName value
     * @return string|null
     */
    public function getGridName()
    {
        return $this->gridName;
    }
    /**
     * Set gridName value
     * @param string $gridName
     * @return \StructType\PricingGrid
     */
    public function setGridName($gridName = null)
    {
        // validation for constraint: string
        if (!is_null($gridName) && !is_string($gridName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gridName, true), gettype($gridName)), __LINE__);
        }
        $this->gridName = $gridName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PricingGrid
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
