<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named getInfo
     * Meta information extracted from the WSDL
     * - documentation: Gets the product image and other data
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $customerNumber
     * @param string $userCredential
     * @param string $productNumber
     * @param string $outlet
     * @return \StructType\ProductInfo|bool
     */
    public function getInfo($customerNumber, $userCredential, $productNumber, $outlet)
    {
        try {
            $this->setResult($this->getSoapClient()->getInfo($customerNumber, $userCredential, $productNumber, $outlet));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getLastModified
     * Meta information extracted from the WSDL
     * - documentation: Gets the last modified time for products
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $customerNumber
     * @param string $userCredential
     * @return \StructType\ProductLastModified[]|bool
     */
    public function getLastModified($customerNumber, $userCredential)
    {
        try {
            $this->setResult($this->getSoapClient()->getLastModified($customerNumber, $userCredential));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getTopSellers
     * Meta information extracted from the WSDL
     * - documentation: Gets the top-selling products
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $customerNumber
     * @param string $userCredential
     * @param string $count
     * @return \StructType\ProductTopSellers|bool
     */
    public function getTopSellers($customerNumber, $userCredential, $count)
    {
        try {
            $this->setResult($this->getSoapClient()->getTopSellers($customerNumber, $userCredential, $count));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getColors
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $customerNumber
     * @param string $userCredential
     * @param string $productNumber
     * @return \StructType\ProductColorData[]|bool
     */
    public function getColors($customerNumber, $userCredential, $productNumber)
    {
        try {
            $this->setResult($this->getSoapClient()->getColors($customerNumber, $userCredential, $productNumber));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getSetupCharges
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $customerNumber
     * @param string $userCredential
     * @param string $productNumber
     * @return \StructType\ProductSetupData[]|bool
     */
    public function getSetupCharges($customerNumber, $userCredential, $productNumber)
    {
        try {
            $this->setResult($this->getSoapClient()->getSetupCharges($customerNumber, $userCredential, $productNumber));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getImages
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $customerNumber
     * @param string $userCredential
     * @param string $productNumber
     * @return \StructType\ProductImageResult|bool
     */
    public function getImages($customerNumber, $userCredential, $productNumber)
    {
        try {
            $this->setResult($this->getSoapClient()->getImages($customerNumber, $userCredential, $productNumber));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getProductSizes
     * Meta information extracted from the WSDL
     * - documentation: Gets the product sizes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $customerNumber
     * @param string $userCredential
     * @param string $productNumber
     * @return \StructType\ProductSize[]|bool
     */
    public function getProductSizes($customerNumber, $userCredential, $productNumber)
    {
        try {
            $this->setResult($this->getSoapClient()->getProductSizes($customerNumber, $userCredential, $productNumber));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getProductArtTemplates
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $customerNumber
     * @param string $userCredential
     * @param string $productNumber
     * @return \StructType\ProductArtTemplate[]|bool
     */
    public function getProductArtTemplates($customerNumber, $userCredential, $productNumber)
    {
        try {
            $this->setResult($this->getSoapClient()->getProductArtTemplates($customerNumber, $userCredential, $productNumber));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ProductArtTemplate[]|\StructType\ProductColorData[]|\StructType\ProductImageResult|\StructType\ProductInfo|\StructType\ProductLastModified[]|\StructType\ProductSetupData[]|\StructType\ProductSize[]|\StructType\ProductTopSellers
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
