<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductLastModified StructType
 * @subpackage Structs
 */
class ProductLastModified extends AbstractStructBase
{
    /**
     * The number
     * @var string
     */
    public $number;
    /**
     * The timeModified
     * @var string
     */
    public $timeModified;
    /**
     * The domain
     * @var string
     */
    public $domain;
    /**
     * Constructor method for ProductLastModified
     * @uses ProductLastModified::setNumber()
     * @uses ProductLastModified::setTimeModified()
     * @uses ProductLastModified::setDomain()
     * @param string $number
     * @param string $timeModified
     * @param string $domain
     */
    public function __construct($number = null, $timeModified = null, $domain = null)
    {
        $this
            ->setNumber($number)
            ->setTimeModified($timeModified)
            ->setDomain($domain);
    }
    /**
     * Get number value
     * @return string|null
     */
    public function getNumber()
    {
        return $this->number;
    }
    /**
     * Set number value
     * @param string $number
     * @return \StructType\ProductLastModified
     */
    public function setNumber($number = null)
    {
        // validation for constraint: string
        if (!is_null($number) && !is_string($number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($number, true), gettype($number)), __LINE__);
        }
        $this->number = $number;
        return $this;
    }
    /**
     * Get timeModified value
     * @return string|null
     */
    public function getTimeModified()
    {
        return $this->timeModified;
    }
    /**
     * Set timeModified value
     * @param string $timeModified
     * @return \StructType\ProductLastModified
     */
    public function setTimeModified($timeModified = null)
    {
        // validation for constraint: string
        if (!is_null($timeModified) && !is_string($timeModified)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($timeModified, true), gettype($timeModified)), __LINE__);
        }
        $this->timeModified = $timeModified;
        return $this;
    }
    /**
     * Get domain value
     * @return string|null
     */
    public function getDomain()
    {
        return $this->domain;
    }
    /**
     * Set domain value
     * @param string $domain
     * @return \StructType\ProductLastModified
     */
    public function setDomain($domain = null)
    {
        // validation for constraint: string
        if (!is_null($domain) && !is_string($domain)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($domain, true), gettype($domain)), __LINE__);
        }
        $this->domain = $domain;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ProductLastModified
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
