<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductTopSellers StructType
 * @subpackage Structs
 */
class ProductTopSellers extends AbstractStructBase
{
    /**
     * The sales
     * Meta information extracted from the WSDL
     * - arrayType: tns:SalesData[]
     * - base: soap-enc:Array
     * - ref: soap-enc:arrayType
     * @var \StructType\SalesData[]
     */
    public $sales;
    /**
     * The quantity
     * Meta information extracted from the WSDL
     * - arrayType: tns:QuantityData[]
     * - base: soap-enc:Array
     * - ref: soap-enc:arrayType
     * @var \StructType\QuantityData[]
     */
    public $quantity;
    /**
     * Constructor method for ProductTopSellers
     * @uses ProductTopSellers::setSales()
     * @uses ProductTopSellers::setQuantity()
     * @param \StructType\SalesData[] $sales
     * @param \StructType\QuantityData[] $quantity
     */
    public function __construct(array $sales = array(), array $quantity = array())
    {
        $this
            ->setSales($sales)
            ->setQuantity($quantity);
    }
    /**
     * Get sales value
     * @return \StructType\SalesData[]|null
     */
    public function getSales()
    {
        return $this->sales;
    }
    /**
     * This method is responsible for validating the values passed to the setSales method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSales method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSalesForArrayConstraintsFromSetSales(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $productTopSellersSalesItem) {
            // validation for constraint: itemType
            if (!$productTopSellersSalesItem instanceof \StructType\SalesData) {
                $invalidValues[] = is_object($productTopSellersSalesItem) ? get_class($productTopSellersSalesItem) : sprintf('%s(%s)', gettype($productTopSellersSalesItem), var_export($productTopSellersSalesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The sales property can only contain items of type \StructType\SalesData, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set sales value
     * @throws \InvalidArgumentException
     * @param \StructType\SalesData[] $sales
     * @return \StructType\ProductTopSellers
     */
    public function setSales(array $sales = array())
    {
        // validation for constraint: array
        if ('' !== ($salesArrayErrorMessage = self::validateSalesForArrayConstraintsFromSetSales($sales))) {
            throw new \InvalidArgumentException($salesArrayErrorMessage, __LINE__);
        }
        $this->sales = $sales;
        return $this;
    }
    /**
     * Add item to sales value
     * @throws \InvalidArgumentException
     * @param \StructType\SalesData $item
     * @return \StructType\ProductTopSellers
     */
    public function addToSales(\StructType\SalesData $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SalesData) {
            throw new \InvalidArgumentException(sprintf('The sales property can only contain items of type \StructType\SalesData, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->sales[] = $item;
        return $this;
    }
    /**
     * Get quantity value
     * @return \StructType\QuantityData[]|null
     */
    public function getQuantity()
    {
        return $this->quantity;
    }
    /**
     * This method is responsible for validating the values passed to the setQuantity method
     * This method is willingly generated in order to preserve the one-line inline validation within the setQuantity method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateQuantityForArrayConstraintsFromSetQuantity(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $productTopSellersQuantityItem) {
            // validation for constraint: itemType
            if (!$productTopSellersQuantityItem instanceof \StructType\QuantityData) {
                $invalidValues[] = is_object($productTopSellersQuantityItem) ? get_class($productTopSellersQuantityItem) : sprintf('%s(%s)', gettype($productTopSellersQuantityItem), var_export($productTopSellersQuantityItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The quantity property can only contain items of type \StructType\QuantityData, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set quantity value
     * @throws \InvalidArgumentException
     * @param \StructType\QuantityData[] $quantity
     * @return \StructType\ProductTopSellers
     */
    public function setQuantity(array $quantity = array())
    {
        // validation for constraint: array
        if ('' !== ($quantityArrayErrorMessage = self::validateQuantityForArrayConstraintsFromSetQuantity($quantity))) {
            throw new \InvalidArgumentException($quantityArrayErrorMessage, __LINE__);
        }
        $this->quantity = $quantity;
        return $this;
    }
    /**
     * Add item to quantity value
     * @throws \InvalidArgumentException
     * @param \StructType\QuantityData $item
     * @return \StructType\ProductTopSellers
     */
    public function addToQuantity(\StructType\QuantityData $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\QuantityData) {
            throw new \InvalidArgumentException(sprintf('The quantity property can only contain items of type \StructType\QuantityData, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->quantity[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ProductTopSellers
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
