<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SegmentsAndDescription StructType
 * @subpackage Structs
 */
class SegmentsAndDescription extends AbstractStructBase
{
    /**
     * The segment
     * @var string
     */
    public $segment;
    /**
     * The description
     * @var string
     */
    public $description;
    /**
     * The segment_link
     * @var string
     */
    public $segment_link;
    /**
     * Constructor method for SegmentsAndDescription
     * @uses SegmentsAndDescription::setSegment()
     * @uses SegmentsAndDescription::setDescription()
     * @uses SegmentsAndDescription::setSegment_link()
     * @param string $segment
     * @param string $description
     * @param string $segment_link
     */
    public function __construct($segment = null, $description = null, $segment_link = null)
    {
        $this
            ->setSegment($segment)
            ->setDescription($description)
            ->setSegment_link($segment_link);
    }
    /**
     * Get segment value
     * @return string|null
     */
    public function getSegment()
    {
        return $this->segment;
    }
    /**
     * Set segment value
     * @param string $segment
     * @return \StructType\SegmentsAndDescription
     */
    public function setSegment($segment = null)
    {
        // validation for constraint: string
        if (!is_null($segment) && !is_string($segment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($segment, true), gettype($segment)), __LINE__);
        }
        $this->segment = $segment;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\SegmentsAndDescription
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get segment_link value
     * @return string|null
     */
    public function getSegment_link()
    {
        return $this->segment_link;
    }
    /**
     * Set segment_link value
     * @param string $segment_link
     * @return \StructType\SegmentsAndDescription
     */
    public function setSegment_link($segment_link = null)
    {
        // validation for constraint: string
        if (!is_null($segment_link) && !is_string($segment_link)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($segment_link, true), gettype($segment_link)), __LINE__);
        }
        $this->segment_link = $segment_link;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SegmentsAndDescription
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
