<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PipCompanionProduct StructType
 * @subpackage Structs
 */
class PipCompanionProduct extends AbstractStructBase
{
    /**
     * The companion_product
     * @var string
     */
    public $companion_product;
    /**
     * The name
     * @var string
     */
    public $name;
    /**
     * Constructor method for PipCompanionProduct
     * @uses PipCompanionProduct::setCompanion_product()
     * @uses PipCompanionProduct::setName()
     * @param string $companion_product
     * @param string $name
     */
    public function __construct($companion_product = null, $name = null)
    {
        $this
            ->setCompanion_product($companion_product)
            ->setName($name);
    }
    /**
     * Get companion_product value
     * @return string|null
     */
    public function getCompanion_product()
    {
        return $this->companion_product;
    }
    /**
     * Set companion_product value
     * @param string $companion_product
     * @return \StructType\PipCompanionProduct
     */
    public function setCompanion_product($companion_product = null)
    {
        // validation for constraint: string
        if (!is_null($companion_product) && !is_string($companion_product)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($companion_product, true), gettype($companion_product)), __LINE__);
        }
        $this->companion_product = $companion_product;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\PipCompanionProduct
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PipCompanionProduct
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
