<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrderType StructType
 * @subpackage Structs
 */
class OrderType extends AbstractStructBase
{
    /**
     * The order_value
     * @var string
     */
    public $order_value;
    /**
     * The order_description
     * @var string
     */
    public $order_description;
    /**
     * The segment_link
     * @var string
     */
    public $segment_link;
    /**
     * Constructor method for OrderType
     * @uses OrderType::setOrder_value()
     * @uses OrderType::setOrder_description()
     * @uses OrderType::setSegment_link()
     * @param string $order_value
     * @param string $order_description
     * @param string $segment_link
     */
    public function __construct($order_value = null, $order_description = null, $segment_link = null)
    {
        $this
            ->setOrder_value($order_value)
            ->setOrder_description($order_description)
            ->setSegment_link($segment_link);
    }
    /**
     * Get order_value value
     * @return string|null
     */
    public function getOrder_value()
    {
        return $this->order_value;
    }
    /**
     * Set order_value value
     * @param string $order_value
     * @return \StructType\OrderType
     */
    public function setOrder_value($order_value = null)
    {
        // validation for constraint: string
        if (!is_null($order_value) && !is_string($order_value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($order_value, true), gettype($order_value)), __LINE__);
        }
        $this->order_value = $order_value;
        return $this;
    }
    /**
     * Get order_description value
     * @return string|null
     */
    public function getOrder_description()
    {
        return $this->order_description;
    }
    /**
     * Set order_description value
     * @param string $order_description
     * @return \StructType\OrderType
     */
    public function setOrder_description($order_description = null)
    {
        // validation for constraint: string
        if (!is_null($order_description) && !is_string($order_description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($order_description, true), gettype($order_description)), __LINE__);
        }
        $this->order_description = $order_description;
        return $this;
    }
    /**
     * Get segment_link value
     * @return string|null
     */
    public function getSegment_link()
    {
        return $this->segment_link;
    }
    /**
     * Set segment_link value
     * @param string $segment_link
     * @return \StructType\OrderType
     */
    public function setSegment_link($segment_link = null)
    {
        // validation for constraint: string
        if (!is_null($segment_link) && !is_string($segment_link)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($segment_link, true), gettype($segment_link)), __LINE__);
        }
        $this->segment_link = $segment_link;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OrderType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
