<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Lids StructType
 * @subpackage Structs
 */
class Lids extends AbstractStructBase
{
    /**
     * The lid_value
     * @var string
     */
    public $lid_value;
    /**
     * The lid_description
     * @var string
     */
    public $lid_description;
    /**
     * The segment_link
     * @var string
     */
    public $segment_link;
    /**
     * Constructor method for Lids
     * @uses Lids::setLid_value()
     * @uses Lids::setLid_description()
     * @uses Lids::setSegment_link()
     * @param string $lid_value
     * @param string $lid_description
     * @param string $segment_link
     */
    public function __construct($lid_value = null, $lid_description = null, $segment_link = null)
    {
        $this
            ->setLid_value($lid_value)
            ->setLid_description($lid_description)
            ->setSegment_link($segment_link);
    }
    /**
     * Get lid_value value
     * @return string|null
     */
    public function getLid_value()
    {
        return $this->lid_value;
    }
    /**
     * Set lid_value value
     * @param string $lid_value
     * @return \StructType\Lids
     */
    public function setLid_value($lid_value = null)
    {
        // validation for constraint: string
        if (!is_null($lid_value) && !is_string($lid_value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lid_value, true), gettype($lid_value)), __LINE__);
        }
        $this->lid_value = $lid_value;
        return $this;
    }
    /**
     * Get lid_description value
     * @return string|null
     */
    public function getLid_description()
    {
        return $this->lid_description;
    }
    /**
     * Set lid_description value
     * @param string $lid_description
     * @return \StructType\Lids
     */
    public function setLid_description($lid_description = null)
    {
        // validation for constraint: string
        if (!is_null($lid_description) && !is_string($lid_description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lid_description, true), gettype($lid_description)), __LINE__);
        }
        $this->lid_description = $lid_description;
        return $this;
    }
    /**
     * Get segment_link value
     * @return string|null
     */
    public function getSegment_link()
    {
        return $this->segment_link;
    }
    /**
     * Set segment_link value
     * @param string $segment_link
     * @return \StructType\Lids
     */
    public function setSegment_link($segment_link = null)
    {
        // validation for constraint: string
        if (!is_null($segment_link) && !is_string($segment_link)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($segment_link, true), gettype($segment_link)), __LINE__);
        }
        $this->segment_link = $segment_link;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Lids
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
