<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ImprintLocations StructType
 * @subpackage Structs
 */
class ImprintLocations extends AbstractStructBase
{
    /**
     * The imprint_value
     * @var string
     */
    public $imprint_value;
    /**
     * The location_description
     * @var string
     */
    public $location_description;
    /**
     * The segment_link
     * @var string
     */
    public $segment_link;
    /**
     * Constructor method for ImprintLocations
     * @uses ImprintLocations::setImprint_value()
     * @uses ImprintLocations::setLocation_description()
     * @uses ImprintLocations::setSegment_link()
     * @param string $imprint_value
     * @param string $location_description
     * @param string $segment_link
     */
    public function __construct($imprint_value = null, $location_description = null, $segment_link = null)
    {
        $this
            ->setImprint_value($imprint_value)
            ->setLocation_description($location_description)
            ->setSegment_link($segment_link);
    }
    /**
     * Get imprint_value value
     * @return string|null
     */
    public function getImprint_value()
    {
        return $this->imprint_value;
    }
    /**
     * Set imprint_value value
     * @param string $imprint_value
     * @return \StructType\ImprintLocations
     */
    public function setImprint_value($imprint_value = null)
    {
        // validation for constraint: string
        if (!is_null($imprint_value) && !is_string($imprint_value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($imprint_value, true), gettype($imprint_value)), __LINE__);
        }
        $this->imprint_value = $imprint_value;
        return $this;
    }
    /**
     * Get location_description value
     * @return string|null
     */
    public function getLocation_description()
    {
        return $this->location_description;
    }
    /**
     * Set location_description value
     * @param string $location_description
     * @return \StructType\ImprintLocations
     */
    public function setLocation_description($location_description = null)
    {
        // validation for constraint: string
        if (!is_null($location_description) && !is_string($location_description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($location_description, true), gettype($location_description)), __LINE__);
        }
        $this->location_description = $location_description;
        return $this;
    }
    /**
     * Get segment_link value
     * @return string|null
     */
    public function getSegment_link()
    {
        return $this->segment_link;
    }
    /**
     * Set segment_link value
     * @param string $segment_link
     * @return \StructType\ImprintLocations
     */
    public function setSegment_link($segment_link = null)
    {
        // validation for constraint: string
        if (!is_null($segment_link) && !is_string($segment_link)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($segment_link, true), gettype($segment_link)), __LINE__);
        }
        $this->segment_link = $segment_link;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ImprintLocations
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
