<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ColorsByProduct StructType
 * @subpackage Structs
 */
class ColorsByProduct extends AbstractStructBase
{
    /**
     * The product
     * @var string
     */
    public $product;
    /**
     * The product_color
     * @var string
     */
    public $product_color;
    /**
     * The color_value
     * @var string
     */
    public $color_value;
    /**
     * The color_descrp
     * @var string
     */
    public $color_descrp;
    /**
     * Constructor method for ColorsByProduct
     * @uses ColorsByProduct::setProduct()
     * @uses ColorsByProduct::setProduct_color()
     * @uses ColorsByProduct::setColor_value()
     * @uses ColorsByProduct::setColor_descrp()
     * @param string $product
     * @param string $product_color
     * @param string $color_value
     * @param string $color_descrp
     */
    public function __construct($product = null, $product_color = null, $color_value = null, $color_descrp = null)
    {
        $this
            ->setProduct($product)
            ->setProduct_color($product_color)
            ->setColor_value($color_value)
            ->setColor_descrp($color_descrp);
    }
    /**
     * Get product value
     * @return string|null
     */
    public function getProduct()
    {
        return $this->product;
    }
    /**
     * Set product value
     * @param string $product
     * @return \StructType\ColorsByProduct
     */
    public function setProduct($product = null)
    {
        // validation for constraint: string
        if (!is_null($product) && !is_string($product)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($product, true), gettype($product)), __LINE__);
        }
        $this->product = $product;
        return $this;
    }
    /**
     * Get product_color value
     * @return string|null
     */
    public function getProduct_color()
    {
        return $this->product_color;
    }
    /**
     * Set product_color value
     * @param string $product_color
     * @return \StructType\ColorsByProduct
     */
    public function setProduct_color($product_color = null)
    {
        // validation for constraint: string
        if (!is_null($product_color) && !is_string($product_color)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($product_color, true), gettype($product_color)), __LINE__);
        }
        $this->product_color = $product_color;
        return $this;
    }
    /**
     * Get color_value value
     * @return string|null
     */
    public function getColor_value()
    {
        return $this->color_value;
    }
    /**
     * Set color_value value
     * @param string $color_value
     * @return \StructType\ColorsByProduct
     */
    public function setColor_value($color_value = null)
    {
        // validation for constraint: string
        if (!is_null($color_value) && !is_string($color_value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($color_value, true), gettype($color_value)), __LINE__);
        }
        $this->color_value = $color_value;
        return $this;
    }
    /**
     * Get color_descrp value
     * @return string|null
     */
    public function getColor_descrp()
    {
        return $this->color_descrp;
    }
    /**
     * Set color_descrp value
     * @param string $color_descrp
     * @return \StructType\ColorsByProduct
     */
    public function setColor_descrp($color_descrp = null)
    {
        // validation for constraint: string
        if (!is_null($color_descrp) && !is_string($color_descrp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($color_descrp, true), gettype($color_descrp)), __LINE__);
        }
        $this->color_descrp = $color_descrp;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ColorsByProduct
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
