<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DisplayProcess StructType
 * @subpackage Structs
 */
class DisplayProcess extends AbstractStructBase
{
    /**
     * The process_value
     * @var string
     */
    public $process_value;
    /**
     * The process_description
     * @var string
     */
    public $process_description;
    /**
     * The segment_link
     * @var string
     */
    public $segment_link;
    /**
     * Constructor method for DisplayProcess
     * @uses DisplayProcess::setProcess_value()
     * @uses DisplayProcess::setProcess_description()
     * @uses DisplayProcess::setSegment_link()
     * @param string $process_value
     * @param string $process_description
     * @param string $segment_link
     */
    public function __construct($process_value = null, $process_description = null, $segment_link = null)
    {
        $this
            ->setProcess_value($process_value)
            ->setProcess_description($process_description)
            ->setSegment_link($segment_link);
    }
    /**
     * Get process_value value
     * @return string|null
     */
    public function getProcess_value()
    {
        return $this->process_value;
    }
    /**
     * Set process_value value
     * @param string $process_value
     * @return \StructType\DisplayProcess
     */
    public function setProcess_value($process_value = null)
    {
        // validation for constraint: string
        if (!is_null($process_value) && !is_string($process_value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($process_value, true), gettype($process_value)), __LINE__);
        }
        $this->process_value = $process_value;
        return $this;
    }
    /**
     * Get process_description value
     * @return string|null
     */
    public function getProcess_description()
    {
        return $this->process_description;
    }
    /**
     * Set process_description value
     * @param string $process_description
     * @return \StructType\DisplayProcess
     */
    public function setProcess_description($process_description = null)
    {
        // validation for constraint: string
        if (!is_null($process_description) && !is_string($process_description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($process_description, true), gettype($process_description)), __LINE__);
        }
        $this->process_description = $process_description;
        return $this;
    }
    /**
     * Get segment_link value
     * @return string|null
     */
    public function getSegment_link()
    {
        return $this->segment_link;
    }
    /**
     * Set segment_link value
     * @param string $segment_link
     * @return \StructType\DisplayProcess
     */
    public function setSegment_link($segment_link = null)
    {
        // validation for constraint: string
        if (!is_null($segment_link) && !is_string($segment_link)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($segment_link, true), gettype($segment_link)), __LINE__);
        }
        $this->segment_link = $segment_link;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DisplayProcess
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
