<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named getSegmentsAndDescription
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $customerNumber
     * @param string $userCredential
     * @return \StructType\SegmentsAndDescription[]|bool
     */
    public function getSegmentsAndDescription($customerNumber, $userCredential)
    {
        try {
            $this->setResult($this->getSoapClient()->getSegmentsAndDescription($customerNumber, $userCredential));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getColorsByProduct
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $customerNumber
     * @param string $userCredential
     * @param string $productNumber
     * @return \StructType\ColorsByProduct[]|bool
     */
    public function getColorsByProduct($customerNumber, $userCredential, $productNumber)
    {
        try {
            $this->setResult($this->getSoapClient()->getColorsByProduct($customerNumber, $userCredential, $productNumber));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getImprintLocations
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $customerNumber
     * @param string $userCredential
     * @param string $productNumber
     * @return \StructType\ImprintLocations[]|bool
     */
    public function getImprintLocations($customerNumber, $userCredential, $productNumber)
    {
        try {
            $this->setResult($this->getSoapClient()->getImprintLocations($customerNumber, $userCredential, $productNumber));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getOrderType
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $customerNumber
     * @param string $userCredential
     * @return \StructType\OrderType[]|bool
     */
    public function getOrderType($customerNumber, $userCredential)
    {
        try {
            $this->setResult($this->getSoapClient()->getOrderType($customerNumber, $userCredential));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getDisplayProcess
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $customerNumber
     * @param string $userCredential
     * @param string $productNumber
     * @return \StructType\DisplayProcess[]|bool
     */
    public function getDisplayProcess($customerNumber, $userCredential, $productNumber)
    {
        try {
            $this->setResult($this->getSoapClient()->getDisplayProcess($customerNumber, $userCredential, $productNumber));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getLids
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $customerNumber
     * @param string $userCredential
     * @return \StructType\Lids[]|bool
     */
    public function getLids($customerNumber, $userCredential)
    {
        try {
            $this->setResult($this->getSoapClient()->getLids($customerNumber, $userCredential));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCarrierCodes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $customerNumber
     * @param string $userCredential
     * @return \StructType\CarrierCodes[]|bool
     */
    public function getCarrierCodes($customerNumber, $userCredential)
    {
        try {
            $this->setResult($this->getSoapClient()->getCarrierCodes($customerNumber, $userCredential));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCompanionProducts
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $customerNumber
     * @param string $userCredential
     * @param string $productNumber
     * @return \StructType\PipCompanionProduct[]|bool
     */
    public function getCompanionProducts($customerNumber, $userCredential, $productNumber)
    {
        try {
            $this->setResult($this->getSoapClient()->getCompanionProducts($customerNumber, $userCredential, $productNumber));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getSizesByColorAndPart
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $customerNumber
     * @param string $userCredential
     * @param string $productNumber
     * @param string $color
     * @return \StructType\PartSize[]|bool
     */
    public function getSizesByColorAndPart($customerNumber, $userCredential, $productNumber, $color)
    {
        try {
            $this->setResult($this->getSoapClient()->getSizesByColorAndPart($customerNumber, $userCredential, $productNumber, $color));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\CarrierCodes[]|\StructType\ColorsByProduct[]|\StructType\DisplayProcess[]|\StructType\ImprintLocations[]|\StructType\Lids[]|\StructType\OrderType[]|\StructType\PartSize[]|\StructType\PipCompanionProduct[]|\StructType\SegmentsAndDescription[]
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
