<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CarrierCodes StructType
 * @subpackage Structs
 */
class CarrierCodes extends AbstractStructBase
{
    /**
     * The carrier_code
     * @var string
     */
    public $carrier_code;
    /**
     * The abbreviation
     * @var string
     */
    public $abbreviation;
    /**
     * The carrier_name
     * @var string
     */
    public $carrier_name;
    /**
     * The valid_carrier
     * @var string
     */
    public $valid_carrier;
    /**
     * Constructor method for CarrierCodes
     * @uses CarrierCodes::setCarrier_code()
     * @uses CarrierCodes::setAbbreviation()
     * @uses CarrierCodes::setCarrier_name()
     * @uses CarrierCodes::setValid_carrier()
     * @param string $carrier_code
     * @param string $abbreviation
     * @param string $carrier_name
     * @param string $valid_carrier
     */
    public function __construct($carrier_code = null, $abbreviation = null, $carrier_name = null, $valid_carrier = null)
    {
        $this
            ->setCarrier_code($carrier_code)
            ->setAbbreviation($abbreviation)
            ->setCarrier_name($carrier_name)
            ->setValid_carrier($valid_carrier);
    }
    /**
     * Get carrier_code value
     * @return string|null
     */
    public function getCarrier_code()
    {
        return $this->carrier_code;
    }
    /**
     * Set carrier_code value
     * @param string $carrier_code
     * @return \StructType\CarrierCodes
     */
    public function setCarrier_code($carrier_code = null)
    {
        // validation for constraint: string
        if (!is_null($carrier_code) && !is_string($carrier_code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($carrier_code, true), gettype($carrier_code)), __LINE__);
        }
        $this->carrier_code = $carrier_code;
        return $this;
    }
    /**
     * Get abbreviation value
     * @return string|null
     */
    public function getAbbreviation()
    {
        return $this->abbreviation;
    }
    /**
     * Set abbreviation value
     * @param string $abbreviation
     * @return \StructType\CarrierCodes
     */
    public function setAbbreviation($abbreviation = null)
    {
        // validation for constraint: string
        if (!is_null($abbreviation) && !is_string($abbreviation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($abbreviation, true), gettype($abbreviation)), __LINE__);
        }
        $this->abbreviation = $abbreviation;
        return $this;
    }
    /**
     * Get carrier_name value
     * @return string|null
     */
    public function getCarrier_name()
    {
        return $this->carrier_name;
    }
    /**
     * Set carrier_name value
     * @param string $carrier_name
     * @return \StructType\CarrierCodes
     */
    public function setCarrier_name($carrier_name = null)
    {
        // validation for constraint: string
        if (!is_null($carrier_name) && !is_string($carrier_name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($carrier_name, true), gettype($carrier_name)), __LINE__);
        }
        $this->carrier_name = $carrier_name;
        return $this;
    }
    /**
     * Get valid_carrier value
     * @return string|null
     */
    public function getValid_carrier()
    {
        return $this->valid_carrier;
    }
    /**
     * Set valid_carrier value
     * @param string $valid_carrier
     * @return \StructType\CarrierCodes
     */
    public function setValid_carrier($valid_carrier = null)
    {
        // validation for constraint: string
        if (!is_null($valid_carrier) && !is_string($valid_carrier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($valid_carrier, true), gettype($valid_carrier)), __LINE__);
        }
        $this->valid_carrier = $valid_carrier;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CarrierCodes
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
