<?php

namespace MoniContract\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfDocumentSignatures ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfDocumentSignatures
 * @subpackage Arrays
 */
class ArrayOfDocumentSignatures extends AbstractStructArrayBase
{
    /**
     * The DocumentSignatures
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \MoniContract\StructType\DocumentSignatures[]
     */
    public $DocumentSignatures;
    /**
     * Constructor method for ArrayOfDocumentSignatures
     * @uses ArrayOfDocumentSignatures::setDocumentSignatures()
     * @param \MoniContract\StructType\DocumentSignatures[] $documentSignatures
     */
    public function __construct(array $documentSignatures = array())
    {
        $this
            ->setDocumentSignatures($documentSignatures);
    }
    /**
     * Get DocumentSignatures value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \MoniContract\StructType\DocumentSignatures[]|null
     */
    public function getDocumentSignatures()
    {
        return isset($this->DocumentSignatures) ? $this->DocumentSignatures : null;
    }
    /**
     * Set DocumentSignatures value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \MoniContract\StructType\DocumentSignatures[] $documentSignatures
     * @return \MoniContract\ArrayType\ArrayOfDocumentSignatures
     */
    public function setDocumentSignatures(array $documentSignatures = array())
    {
        foreach ($documentSignatures as $arrayOfDocumentSignaturesDocumentSignaturesItem) {
            // validation for constraint: itemType
            if (!$arrayOfDocumentSignaturesDocumentSignaturesItem instanceof \MoniContract\StructType\DocumentSignatures) {
                throw new \InvalidArgumentException(sprintf('The DocumentSignatures property can only contain items of \MoniContract\StructType\DocumentSignatures, "%s" given', is_object($arrayOfDocumentSignaturesDocumentSignaturesItem) ? get_class($arrayOfDocumentSignaturesDocumentSignaturesItem) : gettype($arrayOfDocumentSignaturesDocumentSignaturesItem)), __LINE__);
            }
        }
        if (is_null($documentSignatures) || (is_array($documentSignatures) && empty($documentSignatures))) {
            unset($this->DocumentSignatures);
        } else {
            $this->DocumentSignatures = $documentSignatures;
        }
        return $this;
    }
    /**
     * Add item to DocumentSignatures value
     * @throws \InvalidArgumentException
     * @param \MoniContract\StructType\DocumentSignatures $item
     * @return \MoniContract\ArrayType\ArrayOfDocumentSignatures
     */
    public function addToDocumentSignatures(\MoniContract\StructType\DocumentSignatures $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \MoniContract\StructType\DocumentSignatures) {
            throw new \InvalidArgumentException(sprintf('The DocumentSignatures property can only contain items of \MoniContract\StructType\DocumentSignatures, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->DocumentSignatures[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \MoniContract\StructType\DocumentSignatures|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \MoniContract\StructType\DocumentSignatures|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \MoniContract\StructType\DocumentSignatures|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \MoniContract\StructType\DocumentSignatures|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \MoniContract\StructType\DocumentSignatures|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string DocumentSignatures
     */
    public function getAttributeName()
    {
        return 'DocumentSignatures';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \MoniContract\ArrayType\ArrayOfDocumentSignatures
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
