<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://senti.monitronics.net/eContractAPISIT?wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://senti.monitronics.net/eContractAPISIT?wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => \MoniContract\ClassMap::get(),
);
/**
 * Samples for Send ServiceType
 */
$send = new \MoniContract\ServiceType\Send($options);
/**
 * Sample call for SendNonSolicitAgreement operation/method
 */
if ($send->SendNonSolicitAgreement(new \MoniContract\StructType\SendNonSolicitAgreement()) !== false) {
    print_r($send->getResult());
} else {
    print_r($send->getLastError());
}
/**
 * Sample call for SendCreditAuthorization operation/method
 */
if ($send->SendCreditAuthorization(new \MoniContract\StructType\SendCreditAuthorization()) !== false) {
    print_r($send->getResult());
} else {
    print_r($send->getLastError());
}
/**
 * Sample call for SendQuoteEmail operation/method
 */
if ($send->SendQuoteEmail(new \MoniContract\StructType\SendQuoteEmail()) !== false) {
    print_r($send->getResult());
} else {
    print_r($send->getLastError());
}
/**
 * Sample call for SendQuoteEmail2 operation/method
 */
if ($send->SendQuoteEmail2(new \MoniContract\StructType\SendQuoteEmail2()) !== false) {
    print_r($send->getResult());
} else {
    print_r($send->getLastError());
}
/**
 * Samples for Register ServiceType
 */
$register = new \MoniContract\ServiceType\Register($options);
/**
 * Sample call for RegisterNotificationUrl operation/method
 */
if ($register->RegisterNotificationUrl(new \MoniContract\StructType\RegisterNotificationUrl()) !== false) {
    print_r($register->getResult());
} else {
    print_r($register->getLastError());
}
/**
 * Samples for APIV ServiceType
 */
$aPIV = new \MoniContract\ServiceType\APIV($options);
/**
 * Sample call for APIVersion operation/method
 */
if ($aPIV->APIVersion(new \MoniContract\StructType\APIVersion()) !== false) {
    print_r($aPIV->getResult());
} else {
    print_r($aPIV->getLastError());
}
/**
 * Samples for Authenticate ServiceType
 */
$authenticate = new \MoniContract\ServiceType\Authenticate($options);
/**
 * Sample call for AuthenticateUser operation/method
 */
if ($authenticate->AuthenticateUser(new \MoniContract\StructType\AuthenticateUser()) !== false) {
    print_r($authenticate->getResult());
} else {
    print_r($authenticate->getLastError());
}
/**
 * Sample call for AuthenticateUser2 operation/method
 */
if ($authenticate->AuthenticateUser2(new \MoniContract\StructType\AuthenticateUser2()) !== false) {
    print_r($authenticate->getResult());
} else {
    print_r($authenticate->getLastError());
}
/**
 * Samples for Create ServiceType
 */
$create = new \MoniContract\ServiceType\Create($options);
/**
 * Sample call for CreateContract operation/method
 */
if ($create->CreateContract(new \MoniContract\StructType\CreateContract()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateContract2 operation/method
 */
if ($create->CreateContract2(new \MoniContract\StructType\CreateContract2()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateContractConsumer operation/method
 */
if ($create->CreateContractConsumer(new \MoniContract\StructType\CreateContractConsumer()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Samples for Void ServiceType
 */
$void = new \MoniContract\ServiceType\Void($options);
/**
 * Sample call for VoidContract operation/method
 */
if ($void->VoidContract(new \MoniContract\StructType\VoidContract()) !== false) {
    print_r($void->getResult());
} else {
    print_r($void->getLastError());
}
/**
 * Samples for Get ServiceType
 */
$get = new \MoniContract\ServiceType\Get($options);
/**
 * Sample call for GetContract operation/method
 */
if ($get->GetContract(new \MoniContract\StructType\GetContract()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetContractAsPrimary operation/method
 */
if ($get->GetContractAsPrimary(new \MoniContract\StructType\GetContractAsPrimary()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetContractDocumentConsumer operation/method
 */
if ($get->GetContractDocumentConsumer(new \MoniContract\StructType\GetContractDocumentConsumer()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetContractID operation/method
 */
if ($get->GetContractID(new \MoniContract\StructType\GetContractID()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Validate ServiceType
 */
$validate = new \MoniContract\ServiceType\Validate($options);
/**
 * Sample call for ValidateContract2 operation/method
 */
if ($validate->ValidateContract2(new \MoniContract\StructType\ValidateContract2()) !== false) {
    print_r($validate->getResult());
} else {
    print_r($validate->getLastError());
}
/**
 * Samples for Upload ServiceType
 */
$upload = new \MoniContract\ServiceType\Upload($options);
/**
 * Sample call for UploadAttachment operation/method
 */
if ($upload->UploadAttachment(new \MoniContract\StructType\UploadAttachment()) !== false) {
    print_r($upload->getResult());
} else {
    print_r($upload->getLastError());
}
/**
 * Samples for Delete ServiceType
 */
$delete = new \MoniContract\ServiceType\Delete($options);
/**
 * Sample call for DeleteAttachment operation/method
 */
if ($delete->DeleteAttachment(new \MoniContract\StructType\DeleteAttachment()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Samples for Search ServiceType
 */
$search = new \MoniContract\ServiceType\Search($options);
/**
 * Sample call for SearchCreditAuth operation/method
 */
if ($search->SearchCreditAuth(new \MoniContract\StructType\SearchCreditAuth()) !== false) {
    print_r($search->getResult());
} else {
    print_r($search->getLastError());
}
/**
 * Sample call for SearchContracts operation/method
 */
if ($search->SearchContracts(new \MoniContract\StructType\SearchContracts()) !== false) {
    print_r($search->getResult());
} else {
    print_r($search->getLastError());
}
