<?php

namespace MoniContract\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GetContract
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \MoniContract\StructType\GetContract $parameters
     * @return \MoniContract\StructType\GetContractResponse|bool
     */
    public function GetContract(\MoniContract\StructType\GetContract $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetContract($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetContractAsPrimary
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \MoniContract\StructType\GetContractAsPrimary $parameters
     * @return \MoniContract\StructType\GetContractAsPrimaryResponse|bool
     */
    public function GetContractAsPrimary(\MoniContract\StructType\GetContractAsPrimary $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetContractAsPrimary($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetContractID
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \MoniContract\StructType\GetContractID $parameters
     * @return \MoniContract\StructType\GetContractIDResponse|bool
     */
    public function GetContractID(\MoniContract\StructType\GetContractID $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetContractID($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \MoniContract\StructType\GetContractAsPrimaryResponse|\MoniContract\StructType\GetContractIDResponse|\MoniContract\StructType\GetContractResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
