<?php

namespace MoniContract\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DealerDBA StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:DealerDBA
 * @subpackage Structs
 */
class DealerDBA extends AbstractStructBase
{
    /**
     * The ExtensionData
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \MoniContract\StructType\ExtensionDataObject
     */
    public $ExtensionData;
    /**
     * The DBAName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DBAName;
    /**
     * The States
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $States;
    /**
     * Constructor method for DealerDBA
     * @uses DealerDBA::setExtensionData()
     * @uses DealerDBA::setDBAName()
     * @uses DealerDBA::setStates()
     * @param \MoniContract\StructType\ExtensionDataObject $extensionData
     * @param string $dBAName
     * @param string $states
     */
    public function __construct(\MoniContract\StructType\ExtensionDataObject $extensionData = null, $dBAName = null, $states = null)
    {
        $this
            ->setExtensionData($extensionData)
            ->setDBAName($dBAName)
            ->setStates($states);
    }
    /**
     * Get ExtensionData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \MoniContract\StructType\ExtensionDataObject|null
     */
    public function getExtensionData()
    {
        return isset($this->ExtensionData) ? $this->ExtensionData : null;
    }
    /**
     * Set ExtensionData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \MoniContract\StructType\ExtensionDataObject $extensionData
     * @return \MoniContract\StructType\DealerDBA
     */
    public function setExtensionData(\MoniContract\StructType\ExtensionDataObject $extensionData = null)
    {
        if (is_null($extensionData) || (is_array($extensionData) && empty($extensionData))) {
            unset($this->ExtensionData);
        } else {
            $this->ExtensionData = $extensionData;
        }
        return $this;
    }
    /**
     * Get DBAName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDBAName()
    {
        return isset($this->DBAName) ? $this->DBAName : null;
    }
    /**
     * Set DBAName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dBAName
     * @return \MoniContract\StructType\DealerDBA
     */
    public function setDBAName($dBAName = null)
    {
        // validation for constraint: string
        if (!is_null($dBAName) && !is_string($dBAName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dBAName)), __LINE__);
        }
        if (is_null($dBAName) || (is_array($dBAName) && empty($dBAName))) {
            unset($this->DBAName);
        } else {
            $this->DBAName = $dBAName;
        }
        return $this;
    }
    /**
     * Get States value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStates()
    {
        return isset($this->States) ? $this->States : null;
    }
    /**
     * Set States value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $states
     * @return \MoniContract\StructType\DealerDBA
     */
    public function setStates($states = null)
    {
        // validation for constraint: string
        if (!is_null($states) && !is_string($states)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($states)), __LINE__);
        }
        if (is_null($states) || (is_array($states) && empty($states))) {
            unset($this->States);
        } else {
            $this->States = $states;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \MoniContract\StructType\DealerDBA
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
