<?php

namespace eContract\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Contract ServiceType
 * @subpackage Services
 */
class Contract extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ContractReadyForArchival
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \eContract\StructType\ContractReadyForArchival $parameters
     * @return \eContract\StructType\ContractReadyForArchivalResponse|bool
     */
    public function ContractReadyForArchival(\eContract\StructType\ContractReadyForArchival $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ContractReadyForArchival($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \eContract\StructType\ContractReadyForArchivalResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
