<?php

namespace eContract\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NextSigner StructType
 * @subpackage Structs
 */
class NextSigner extends AbstractStructBase
{
    /**
     * The EnvelopeID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EnvelopeID;
    /**
     * The NextSigner
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $NextSigner;
    /**
     * Constructor method for NextSigner
     * @uses NextSigner::setEnvelopeID()
     * @uses NextSigner::setNextSigner()
     * @param string $envelopeID
     * @param int $nextSigner
     */
    public function __construct($envelopeID = null, $nextSigner = null)
    {
        $this
            ->setEnvelopeID($envelopeID)
            ->setNextSigner($nextSigner);
    }
    /**
     * Get EnvelopeID value
     * @return string|null
     */
    public function getEnvelopeID()
    {
        return $this->EnvelopeID;
    }
    /**
     * Set EnvelopeID value
     * @param string $envelopeID
     * @return \eContract\StructType\NextSigner
     */
    public function setEnvelopeID($envelopeID = null)
    {
        // validation for constraint: pattern
        if (is_scalar($envelopeID) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $envelopeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($envelopeID, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($envelopeID) && !is_string($envelopeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($envelopeID)), __LINE__);
        }
        $this->EnvelopeID = $envelopeID;
        return $this;
    }
    /**
     * Get NextSigner value
     * @return int|null
     */
    public function getNextSigner()
    {
        return $this->NextSigner;
    }
    /**
     * Set NextSigner value
     * @param int $nextSigner
     * @return \eContract\StructType\NextSigner
     */
    public function setNextSigner($nextSigner = null)
    {
        // validation for constraint: int
        if (!is_null($nextSigner) && !is_numeric($nextSigner)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($nextSigner)), __LINE__);
        }
        $this->NextSigner = $nextSigner;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \eContract\StructType\NextSigner
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
