<?php

namespace eContract\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ContractReadyForArchival StructType
 * @subpackage Structs
 */
class ContractReadyForArchival extends AbstractStructBase
{
    /**
     * The EnvelopeId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EnvelopeId;
    /**
     * The CSNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CSNumber;
    /**
     * Constructor method for ContractReadyForArchival
     * @uses ContractReadyForArchival::setEnvelopeId()
     * @uses ContractReadyForArchival::setCSNumber()
     * @param string $envelopeId
     * @param string $cSNumber
     */
    public function __construct($envelopeId = null, $cSNumber = null)
    {
        $this
            ->setEnvelopeId($envelopeId)
            ->setCSNumber($cSNumber);
    }
    /**
     * Get EnvelopeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEnvelopeId()
    {
        return isset($this->EnvelopeId) ? $this->EnvelopeId : null;
    }
    /**
     * Set EnvelopeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $envelopeId
     * @return \eContract\StructType\ContractReadyForArchival
     */
    public function setEnvelopeId($envelopeId = null)
    {
        // validation for constraint: string
        if (!is_null($envelopeId) && !is_string($envelopeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($envelopeId)), __LINE__);
        }
        if (is_null($envelopeId) || (is_array($envelopeId) && empty($envelopeId))) {
            unset($this->EnvelopeId);
        } else {
            $this->EnvelopeId = $envelopeId;
        }
        return $this;
    }
    /**
     * Get CSNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCSNumber()
    {
        return isset($this->CSNumber) ? $this->CSNumber : null;
    }
    /**
     * Set CSNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cSNumber
     * @return \eContract\StructType\ContractReadyForArchival
     */
    public function setCSNumber($cSNumber = null)
    {
        // validation for constraint: string
        if (!is_null($cSNumber) && !is_string($cSNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cSNumber)), __LINE__);
        }
        if (is_null($cSNumber) || (is_array($cSNumber) && empty($cSNumber))) {
            unset($this->CSNumber);
        } else {
            $this->CSNumber = $cSNumber;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \eContract\StructType\ContractReadyForArchival
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
