<?php

namespace eContract\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Resend ServiceType
 * @subpackage Services
 */
class Resend extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ResendEnvelope
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \eContract\StructType\ResendEnvelope $parameters
     * @return \eContract\StructType\ResendEnvelopeResponse|bool
     */
    public function ResendEnvelope(\eContract\StructType\ResendEnvelope $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ResendEnvelope($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \eContract\StructType\ResendEnvelopeResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
